package com.xebialabs.xlrelease.ascode.yaml.parser

import com.xebialabs.ascode.yaml.Specs
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.ascode.yaml.parser.{DefinitionParser, RolesSpecParser}
import com.xebialabs.xlrelease.ascode.utils.StaticVariables._
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.io.InputStream

@Component
@Autowired
class XLRDefinitionParser {
  private val xlReleaseNamespace = "xl-release"

  val specs = Specs(Map(
    (xlReleaseNamespace -> XLR_TEMPLATE_KIND) -> CiParser,
    (xlReleaseNamespace -> XLR_RELEASE_KIND) -> StartReleaseParser,
    (xlReleaseNamespace -> XLR_PERMISSIONS_KIND) -> XLRPermissionSpecParser(),
    (xlReleaseNamespace -> XLR_ROLES_KIND) -> RolesSpecParser,
    (xlReleaseNamespace -> XLR_USERS_KIND) -> XLRUsersSpecParser,
    (xlReleaseNamespace -> XLR_ENVIRONMENTS_KIND) -> EnvironmentsSpecParser,
    (xlReleaseNamespace -> XLR_APPLICATIONS_KIND) -> ApplicationsSpecParser
  ))

  private val parser = new DefinitionParser(specs)

  def parse(content: InputStream): Definition = parser.parse(content)

  def parse(string: String): Definition = parser.parse(string)
}
