package com.xebialabs.xlrelease.ascode.rest.support

import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}

@Component
@Provider
@Produces(Array("application/zip"))
class WriterConfigZipWriter extends MessageBodyWriter[WriterConfig] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[WriterConfig].isAssignableFrom(`type`)

  override def writeTo(config: WriterConfig,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = XLRDefinitionWriter().writeZip(entityStream, config)
}

@Component
@Provider
@Produces(Array("text/vnd.yaml"))
class WriterConfigYamlWriter extends MessageBodyWriter[WriterConfig] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[WriterConfig].isAssignableFrom(`type`)

  override def writeTo(config: WriterConfig,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = XLRDefinitionWriter().writeYaml(entityStream, config)
}