package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters
import com.xebialabs.xlrelease.environments.service.EnvironmentService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class EnvironmentFilterStringReferenceCreationHandler(environmentService: EnvironmentService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[EnvironmentFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[EnvironmentFilter]
    val envName = filter.getEnvironmentId
    val searchFilter = new EnvironmentFilters
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("environmentId")

    searchFilter.setTitle(envName)

    val results = environmentService.searchEnvironments(searchFilter)
    val value = results.asScala
      .map(env => Ids.getName(env.getId))
      .headOption
      .getOrElse(throw new AsCodeException(s"Environment with name $envName was not found. Please create it first before using it."))
    config.ci.setId("-1")

    StringReferenceContainer(config.ci, Map(descriptor -> Some(value)))
  }
}
