package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings.FOLDER_VERSIONING_YAML_FILENAME
import com.xebialabs.xlrelease.scm.connector.{BinaryFile, ScmBlobs, ScmException}
import com.xebialabs.xlrelease.versioning.ascode.scm.DefinitionsGenerator
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.SingleFileStrategy.{SINGLE_FILE, SINGLE_FILE_VALUE}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.io.ByteArrayOutputStream

object SingleFileStrategy {
  val SINGLE_FILE = "singleFile"
  val SINGLE_FILE_VALUE = "Single file"
}

@Component
class SingleFileStrategy @Autowired()(definitionsGenerator: DefinitionsGenerator) extends VersioningStyleStrategy {

  override def generateFolder(folderId: String, config: FolderVersioningSettings, filePath: String): GeneratedFolder = {
    try {
      val definitions = definitionsGenerator.generate(folderId, config)

      val stream = new ByteArrayOutputStream()
      val generateCtxs = XLRDefinitionWriter().writeYaml(stream, WriterConfig(definitions, writeSecrets = false, writeDefaults = false))
      val secrets = generateCtxs.flatMap(_.secrets).toMap

      GeneratedFolder(
        ScmBlobs(Seq(BinaryFile(filePath, () => stream.toByteArray))),
        definitions,
        secrets
      )
    } catch {
      case e: AsCodeException => throw ScmException(e.getMessage, e.getCause)
    }
  }

  override def fetchChildDefinitionsIfNecesarry(version: String,
                                                config: FolderVersioningSettings,
                                                scmConnector: AsCodeJGitConnector,
                                                definitionsInReleaseFile: List[Definition]): List[Definition] = definitionsInReleaseFile

  override def getDefinitionsFilenamesFrom(definition: Definition): List[String] = List(FOLDER_VERSIONING_YAML_FILENAME)

  override def getVersionableFileNames(folderId: String, settings: FolderVersioningSettings): List[String] = List(FOLDER_VERSIONING_YAML_FILENAME)

  override def name: String = SINGLE_FILE

  override def value: String = SINGLE_FILE_VALUE
}
