package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.DeliveryPatternApi
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters
import com.xebialabs.xlrelease.ascode.utils.Utils.enforcePermissionsOnGenerate
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService
import com.xebialabs.xlrelease.domain.delivery.Delivery
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.repository.Page
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Optional.{empty, ofNullable}
import scala.collection.immutable.ListMap
import scala.jdk.CollectionConverters._

@Component
class DeliveryPatternAsCodeGenerator @Autowired()(patternApi: DeliveryPatternApi, deliveryPatternService: DeliveryPatternService)
  extends GenerateStrategy[Delivery] {
  /**
   * This order will be used to sort generate strategies
   */
  override val generateOrder: Double = 10

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateDeliveryPatterns
  }

  override protected def generateFolder(config: CiGenerateConfig): ListMap[Option[Folder], List[Delivery]] = {
    val totalResultPerPage = 100L
    config.folders.foldLeft(ListMap.empty[Option[Folder], List[Delivery]]) { case (acc, folder) =>
      val filters = new DeliveryPatternFilters()
      filters.setFolderId(folder.getId)

      acc + (Some(folder) -> CiGenerator.paginate { page =>
        val patterns = deliveryPatternService.searchPatterns(
          filters,
          Page.parse(ofNullable(page), ofNullable(totalResultPerPage), empty),
          enforcePermissionsOnGenerate(config, folder.getId)
        ).asScala.toList

        patterns -> (patterns.size < totalResultPerPage)
      })
    }
  }
}
