package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields
import com.xebialabs.xlrelease.repository.Ids
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class MetadataProcessor @Autowired()(folderAsCodeService: FolderAsCodeService) extends Logging {

  private def getHomeFolderId(home: String): Option[String] = {
    if (home == null || home.isEmpty || home.equals(Ids.SEPARATOR)) {
      None
    } else if (home.startsWith(Ids.SEPARATOR)) {
      AsCodeException.throwDocumentFieldException("metadata", "The home field should not start with '/'")
    } else {
      folderAsCodeService.createFolderHierarchy(home).map(_.getId)
    }
  }

  def processHomeFolder(maybeHomeFolder: Option[String]): Option[String] = {
    maybeHomeFolder.flatMap(getHomeFolderId)
  }

  def processMetadata(kind: String, metadata: Option[Map[String, String]]): Map[String, String] = {
    logger.debug("Processing metadata")

    metadata match {
      case Some(meta) if meta != Map.empty =>
        logger.debug(s"Metadata found: ${meta.toString}")
        processHomeFolder(meta.get(MetadataFields.HOMEFOLDER.toString)).foldLeft(meta)((initialMeta, homeFolder) =>
          initialMeta + (MetadataFields.FOLDER.toString -> homeFolder)
        )
      case _ =>
        logger.debug("No metadata to process")
        Map.empty
    }
  }
}
