package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.domain._
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class UserInputTaskGeneratorHandler @Autowired() extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[UserInputTask]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val userInputTask = ci.asInstanceOf[UserInputTask]
    Option(userInputTask.getVariables)
      .to(LazyList)
      .flatMap(_.asScala.toList)
      .foreach(variable => variable.setId(variable.getKey))
  }
}
