package com.xebialabs.xlrelease.versioning.ascode.form

import com.xebialabs.xlrelease.scm.data.VersionInfo
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage

import java.util
import scala.beans.BeanProperty

class CreateVersionForm {
  @BeanProperty
  var name: String = _
  @BeanProperty
  var description: String = _
}

class CreateVersionResult extends VersionInfo {
  @BeanProperty
  var errors: java.util.List[CreateVersionError] = new util.ArrayList[CreateVersionError]()
}

object CreateVersionResult {
  def versionInfoToCreateVersionResult(info: VersionInfo): CreateVersionResult = {
    val result = new CreateVersionResult
    result.name = info.name
    result.author = info.author
    result.commiter = info.commiter
    result.commitHash = info.commitHash
    result.commitTime = info.commitTime
    result.fullMessage = info.fullMessage
    result.shortMessage = info.shortMessage
    result
  }
}

class CreateVersionError {
  @BeanProperty
  var id: String = _

  @BeanProperty
  var ciType: String = _

  @BeanProperty
  var title: String = _

  @BeanProperty
  var folder: String = _

  @BeanProperty
  var property: String = _

  @BeanProperty
  var message: String = _
}

object CreateVersionError {
  def validationMessageToError(message: ValidationMessage): CreateVersionError = {
    val error = new CreateVersionError
    error.id = message.ci.id
    error.ciType = message.ci.ciTypeDisplayName
    error.title = message.ci.title
    error.folder = message.ci.folderPath
    error.property = message.property
    error.message = message.message
    error
  }
}
