/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.ascode.scm;

import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.ascode.yaml.model.ImportsSpec;
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings$;
import com.xebialabs.xlrelease.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.scm.connector.ScmBlobs;
import com.xebialabs.xlrelease.scm.connector.ScmException;
import com.xebialabs.xlrelease.scm.connector.ScmException$;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningConfigService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService$;
import com.xebialabs.xlrelease.versioning.ascode.scm.YamlUtils$;
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00151\u0006\u0001\"\u0001X\u0011\u001da\u0007!%A\u0005\u00025DQa\u001e\u0001\u0005\naDq!a\t\u0001\t\u0013\t)\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0002\u001f\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u0004&/\u001a<jK^\u001cVM\u001d<jG\u0016T!\u0001E\t\u0002\u0007M\u001cWN\u0003\u0002\u0013'\u00051\u0011m]2pI\u0016T!\u0001F\u000b\u0002\u0015Y,'o]5p]&twM\u0003\u0002\u0017/\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00031e\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003Q\u0019wN\u001c8fGR|'/\u00138ji&\fG.\u001b>feB\u0011Q\u0005K\u0007\u0002M)\u0011qeD\u0001\nG>tg.Z2u_JL!!\u000b\u0014\u0003=\u0005\u001b8i\u001c3f\u0015\u001eKGoQ8o]\u0016\u001cGo\u001c:J]&$\u0018.\u00197ju\u0016\u0014\u0018!\b4pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0011\u00051jS\"A\b\n\u00059z!!\b$pY\u0012,'OV3sg&|g.\u001b8h\u0007>tg-[4TKJ4\u0018nY3\u0002/Y,'o]5p]&twm\u0015;zY\u0016\u0014Vm]8mm\u0016\u0014\bCA\u00195\u001b\u0005\u0011$BA\u001a\u0010\u0003!\u0019HO]1uK\u001eL\u0018BA\u001b3\u0005i1VM]:j_:LgnZ*ue\u0006$XmZ=SKN|GN^3s\u0003A!WMZ5oSRLwN\u001c)beN,'\u000f\u0005\u00029}5\t\u0011H\u0003\u0002;w\u00051\u0001/\u0019:tKJT!\u0001P\u001f\u0002\te\fW\u000e\u001c\u0006\u0003%UI!aP\u001d\u0003'ac%\u000bR3gS:LG/[8o!\u0006\u00148/\u001a:\u0002\rqJg.\u001b;?)\u0015\u00115\tR#G!\ta\u0003\u0001C\u0003$\u000b\u0001\u0007A\u0005C\u0003+\u000b\u0001\u00071\u0006C\u00030\u000b\u0001\u0007\u0001\u0007C\u00037\u000b\u0001\u0007q\u0007\u000b\u0002\u0006\u0011B\u0011\u0011\nV\u0007\u0002\u0015*\u00111\nT\u0001\u000bC:tw\u000e^1uS>t'BA'O\u0003\u001d1\u0017m\u0019;pefT!a\u0014)\u0002\u000b\t,\u0017M\\:\u000b\u0005E\u0013\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003M\u000b1a\u001c:h\u0013\t)&JA\u0005BkR|w/\u001b:fI\u0006yq-\u001a8fe\u0006$X\r\u0015:fm&,w\u000f\u0006\u0003YG\u0016T\u0007CA-a\u001d\tQf\f\u0005\u0002\\?5\tAL\u0003\u0002^7\u00051AH]8pizJ!aX\u0010\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?~AQ\u0001\u001a\u0004A\u0002a\u000b\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0005\u0006M\u001a\u0001\raZ\u0001\bm\u0016\u00148/[8o!\rq\u0002\u000eW\u0005\u0003S~\u0011aa\u00149uS>t\u0007bB6\u0007!\u0003\u0005\r\u0001W\u0001\tM&dWMT1nK\u0006Ir-\u001a8fe\u0006$X\r\u0015:fm&,w\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005q'F\u0001-pW\u0005\u0001\bCA9v\u001b\u0005\u0011(BA:u\u0003%)hn\u00195fG.,GM\u0003\u0002L?%\u0011aO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF4f]\u0016\u0014\u0018\r^3WKJ\u001c\u0018n\u001c8Qe\u00164\u0018.Z<\u0015\u0011e|\u0018\u0011AA\u000b\u0003?\u0001\"A_?\u000e\u0003mT!a\n?\u000b\u0005A)\u0012B\u0001@|\u0005)\u0011\u0015N\\1ss\u001aKG.\u001a\u0005\u0006W\"\u0001\r\u0001\u0017\u0005\b\u0003\u0007A\u0001\u0019AA\u0003\u0003\u0019\u0019wN\u001c4jOB!\u0011qAA\t\u001b\t\tIAC\u0002\u0013\u0003\u0017Q1\u0001FA\u0007\u0015\r\ty!F\u0001\u0007I>l\u0017-\u001b8\n\t\u0005M\u0011\u0011\u0002\u0002\u0019\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cV\r\u001e;j]\u001e\u001c\bbBA\f\u0011\u0001\u0007\u0011\u0011D\u0001\u0010M&dWm\u001d+p\u0007\",7m[8viB!a$a\u0007Y\u0013\r\tib\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003CA\u0001\u0019\u0001-\u0002\u0007Y,'/\u0001\u000ehK:,'/\u0019;f+:4XM]:j_:,G\r\u0015:fm&,w\u000fF\u0004z\u0003O\tI#a\u000b\t\u000b\u0011L\u0001\u0019\u0001-\t\u000b-L\u0001\u0019\u0001-\t\u000f\u00055\u0012\u00021\u0001\u0002\u0006\u0005A1/\u001a;uS:<7/A\nhKR4\u0015\u000e\\3t\r>\u00148\t[3dW>,H\u000f\u0006\u0004\u0002\u001a\u0005M\u0012Q\u0007\u0005\u0006W*\u0001\r\u0001\u0017\u0005\b\u0003\u0007Q\u0001\u0019AA\u0003\u0003M1XM]5gsJ+\u0017/^3ti\u0016$g)\u001b7f)!\tY$!\u0011\u0002L\u00055\u0003c\u0001\u0010\u0002>%\u0019\u0011qH\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007Z\u0001\u0019AA#\u0003)\u0019\u0007.Z2lK\u0012|U\u000f\u001e\t\u0004u\u0006\u001d\u0013bAA%w\nA1kY7CY>\u00147\u000fC\u0003l\u0017\u0001\u0007\u0001\fC\u0004\u0002\u0004-\u0001\r!!\u0002\u0002!\u001d,GOU3rk\u0016\u001cH/\u001a3GS2,G#B=\u0002T\u0005U\u0003bBA\"\u0019\u0001\u0007\u0011Q\t\u0005\u0006W2\u0001\r\u0001W\u0001\fO\u0016$8+\u001a;uS:<7\u000f\u0006\u0003\u0002\u0006\u0005m\u0003\"\u00023\u000e\u0001\u0004A\u0006f\u0001\u0001\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002fA\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI'a\u0019\u0003\u0013\r{W\u000e]8oK:$\b")
public class FolderVersioningPreviewService {
    private final AsCodeJGitConnectorInitializer connectorInitializer;
    private final FolderVersioningConfigService folderVersioningConfigService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final XLRDefinitionParser definitionParser;

    public String generatePreview(String folderId, Option<String> version, String fileName) {
        return (String)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> {
            BinaryFile binaryFile;
            FolderVersioningSettings config = this.getSettings(folderId);
            String finalFileName = fileName.isEmpty() ? FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME() : fileName;
            String[] filesToCheckout = this.getFilesForCheckout(finalFileName, config);
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                String ver = (String)some.value();
                binaryFile = this.generateVersionPreview(finalFileName, config, filesToCheckout, ver);
            } else if (None$.MODULE$.equals(option)) {
                binaryFile = this.generateUnversionedPreview(folderId, finalFileName, config);
            } else {
                throw new MatchError((Object)option);
            }
            BinaryFile blobs = binaryFile;
            return new String((byte[])blobs.getContent().apply(), StandardCharsets.UTF_8);
        });
    }

    public String generatePreview$default$3() {
        return FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME();
    }

    private BinaryFile generateVersionPreview(String fileName, FolderVersioningSettings config, String[] filesToCheckout, String ver) {
        String filenameWithPath = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config.scmPath(), fileName);
        return (BinaryFile)Using$.MODULE$.resource((Object)this.connectorInitializer.init(config), (Function1 & Serializable)scmConnector -> {
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> scmConnector.checkout(filesToCheckout, ver, false));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ScmBlobs checkedOut = (ScmBlobs)success.value();
                if (!fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
                    this.verifyRequestedFile(checkedOut, fileName, config);
                }
                return this.getRequestedFile(checkedOut, filenameWithPath);
            }
            if (try_ instanceof Failure) {
                ScmException scmException;
                bl = true;
                failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (ex instanceof ScmException && (scmException = (ScmException)ex).getMessage().contains("No definition file found for tag")) {
                    throw new NotFoundException(scmException.getMessage(), new Object[0]);
                }
            }
            if (bl) {
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError((Object)try_);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private BinaryFile generateUnversionedPreview(String folderId, String fileName, FolderVersioningSettings settings) {
        Seq allFiles = this.versioningStyleResolver.resolve(settings.versioningStyle()).generateFolder(folderId, settings).blob().filesToAdd();
        Seq requestedFile = (Seq)allFiles.filter((Function1 & Serializable)binaryFile -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$generateUnversionedPreview$1(fileName, binaryFile)));
        if (requestedFile.isEmpty()) {
            throw new NotFoundException("Invalid file requested", new Object[0]);
        }
        return (BinaryFile)requestedFile.head();
    }

    private String[] getFilesForCheckout(String fileName, FolderVersioningSettings config) {
        String scmPath = config.scmPath();
        if (fileName.equals(FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())) {
            return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, fileName)});
        }
        return (String[])((Object[])new String[]{FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, fileName), FolderVersioningSettings$.MODULE$.getDefinitionsPath(scmPath, FolderVersioningSettings$.MODULE$.FOLDER_VERSIONING_YAML_FILENAME())});
    }

    public void verifyRequestedFile(ScmBlobs checkedOut, String fileName, FolderVersioningSettings config) {
        String releasefileName = FolderVersioningSettings$.MODULE$.getDefinitionsPath(config.scmPath(), FolderVersioningSettings$.MODULE$.getDefinitionsPath$default$2());
        BinaryFile releasefile = (BinaryFile)checkedOut.filesToAdd().find((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$verifyRequestedFile$1(releasefileName, file))).get();
        String releasefileYaml = new String((byte[])releasefile.getContent().apply(), StandardCharsets.UTF_8);
        List<String> specs = YamlUtils$.MODULE$.preprocessYaml(releasefileYaml);
        Definition releasefileDefinition = this.definitionParser.parse((String)specs.head());
        List<String> imports = ((ImportsSpec)releasefileDefinition.spec()).imports();
        if (!imports.contains((Object)fileName)) {
            throw new ScmException("The requested file is not amongst the imports.", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        }
    }

    public BinaryFile getRequestedFile(ScmBlobs checkedOut, String fileName) {
        return (BinaryFile)checkedOut.filesToAdd().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningPreviewService.$anonfun$getRequestedFile$1(fileName, x$1))).get();
    }

    public FolderVersioningSettings getSettings(String folderId) {
        return (FolderVersioningSettings)((Object)FolderVersioningService$.MODULE$.wrapExceptions().apply((Function0 & Serializable)() -> (FolderVersioningSettings)((Object)((Object)$this.folderVersioningConfigService.findSettings(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new ScmException("No version control settings defined for folder", ScmException$.MODULE$.apply$default$2(), ScmException$.MODULE$.apply$default$3());
        })))));
    }

    public static final /* synthetic */ boolean $anonfun$generateUnversionedPreview$1(String fileName$3, BinaryFile binaryFile) {
        return FolderVersioningSettings$.MODULE$.getfilename(binaryFile.fileName()).equals(fileName$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRequestedFile$1(String releasefileName$1, BinaryFile file) {
        return file.fileName().equals(releasefileName$1);
    }

    public static final /* synthetic */ boolean $anonfun$getRequestedFile$1(String fileName$4, BinaryFile x$1) {
        return x$1.fileName().equals(fileName$4);
    }

    @Autowired
    public FolderVersioningPreviewService(AsCodeJGitConnectorInitializer connectorInitializer, FolderVersioningConfigService folderVersioningConfigService, VersioningStrategyResolver versioningStyleResolver, XLRDefinitionParser definitionParser) {
        this.connectorInitializer = connectorInitializer;
        this.folderVersioningConfigService = folderVersioningConfigService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.definitionParser = definitionParser;
    }
}

