package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.xlrelease.versioning.ascode.scm.VersioningStyle
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Component
class VersioningStrategyResolver @Autowired()(versioningStrategies: JList[VersioningStyleStrategy]) {

  lazy val supportedStyles: List[VersioningStyle] = versioningStrategies.asScala.sortBy(_.maxNumOfFilesGenerated).map(str => new VersioningStyle(str.name, str.value)).toList

  def resolve(versioningStyle: String): VersioningStyleStrategy = {
    versioningStrategies.asScala.filter(strategy => strategy.name.equals(versioningStyle)).head
  }

}
