package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.DependsOn
import org.springframework.stereotype.Service

import java.util
import scala.jdk.CollectionConverters._

@Service
@DependsOn(Array("workdirHolder"))
@Autowired
class DefinitionInterpreterService(specInterpreters: util.List[SpecInterpreter]) {
  private val handle = SpecInterpreter.compose(specInterpreters.asScala)

  def interpret(context: InterpreterContext): AsCodeResponse = {
    handle(context)
  }
}
