package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.ChangedIds
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_FOLDER_VERSIONS
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningConfigService
import com.xebialabs.xltype.serialization.CiReference
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters.CollectionHasAsScala
import scala.util.{Failure, Try}

@Service
class FolderVersioningAsCodeService(configurationRepository: ConfigurationRepository,
                                    folderVersioningConfigService: FolderVersioningConfigService,
                                    referenceSolver: ReferenceSolver,
                                    permissionChecker: PermissionChecker,
                                    folderAsCodeService: FolderAsCodeService) {

  def createConfiguration(folderVersioningSettings: FolderVersioningSettings, references: List[CiReference],
                          folderId: Option[String], folderPath: Option[String]): ChangedIds = {
    val parentFolder = folderId.orNull
    permissionChecker.check(EDIT_FOLDER_VERSIONS, parentFolder)
    val existingFolderVersionSettings = findAllSettings(parentFolder).getOrElse(List.empty)

    referenceSolver.resolveReferences(folderVersioningSettings, references, parentFolder)
    folderVersioningSettings.setFolderId(parentFolder)
    Try(folderVersioningConfigService.validateConfigData(folderVersioningSettings,
      folderPath.getOrElse(folderAsCodeService.findFolderTitleById(parentFolder)))) match {
      case Failure(exception) => throw new AsCodeException(exception.getMessage)
      case _ =>
    }
    folderVersioningConfigService.createOrUpdateSettings(folderVersioningSettings)
    if (existingFolderVersionSettings.nonEmpty) {
      CI.ids.withUpdated(existingFolderVersionSettings.map(entry => entry.getId))
    } else {
      CI.ids.withCreated(folderVersioningSettings.getId)
    }
  }

  def findAllSettings(folderId: String): Option[List[FolderVersioningSettings]] = {
    Option(
      configurationRepository.
        findAllByTypeAndTitle[FolderVersioningSettings](Type.valueOf(classOf[FolderVersioningSettings]), null, folderId, folderOnly = true)
        .asScala
        .toList
    )
  }

}
