package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.ascode.utils.Utils.filterFolderOnGeneratePermissions
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.VIEW_FOLDER_VERSIONS
import org.springframework.stereotype.Component

import scala.collection.immutable.ListMap
import scala.jdk.CollectionConverters.CollectionHasAsScala

@Component
class FolderVersioningAsCodeGenerator(configurationRepository: ConfigurationRepository,
                                      permissionChecker: PermissionChecker)
  extends GenerateStrategy[FolderVersioningSettings] {

  val ciType = Type.valueOf(classOf[FolderVersioningSettings])
  /**
   * This order will be used to sort generate strategies
   */
  override val generateOrder: Double = 31

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateFolderVersioning
  }

  override protected def generateFolder(config: CiGenerateConfig): Map[Option[Folder], List[FolderVersioningSettings]] = {
    config.folders
      .filter(folder => filterFolderOnGeneratePermissions(config, folder.getId) || permissionChecker.hasPermission(VIEW_FOLDER_VERSIONS, folder.getId))
      .foldLeft(ListMap.empty[Option[Folder], List[FolderVersioningSettings]]) {
        case (accumulator, folder) =>
          accumulator + (Some(folder) -> {
            configurationRepository.
              findAllByTypeAndTitle[FolderVersioningSettings](ciType, null, folder.getId, folderOnly = true)
              .asScala.toList

          }
            )
      }
  }

  override protected def filter(results: Map[Option[Folder],
    List[FolderVersioningSettings]], ciTitle: String): Map[Option[Folder], List[FolderVersioningSettings]] = {
    results
  }


}
