package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.api.v1.EnvironmentLabelApi
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentLabelFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class EnvironmentLabelFilterGeneratorHandler(
                                              environmentLabelApi: EnvironmentLabelApi
                                            ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[EnvironmentLabelFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val filter = ci.asInstanceOf[EnvironmentLabelFilter]

    if (filter.getEnvironmentLabelId != null) {
      val env = environmentLabelApi.getById(filter.getEnvironmentLabelId)
      filter.setEnvironmentLabelId(env.getTitle)
    }
  }
}
