package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentStageFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JavaList}
import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

@Component
@Autowired
class DeploymentsByStageDashboardStringReferenceCreationHandler() extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    "xlrelease.DeploymentsByStageDashboard" == config.ci.getType.toString
  }

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val dashboard = config.ci.asInstanceOf[Dashboard]
    val descriptor = config.ci.getType.getDescriptor.getPropertyDescriptor("stageIds")


    val stageIds = dashboard.getTiles.asScala.flatMap { tile =>
      Try(tile.getProperty[JavaList[ReportFilter]]("filters")) match {
        case Success(filters) =>
          filters.asScala.filter(_.isInstanceOf[EnvironmentStageFilter]).map(_.asInstanceOf[EnvironmentStageFilter].getEnvironmentStageId)
        case Failure(_) => List.empty
      }
    }.distinct.asJava

    StringReferenceContainer(dashboard, Map(descriptor -> Some(stageIds)))
  }
}
