package com.xebialabs.xlrelease.ascode.service.spec

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.TaskInfo
import com.xebialabs.xlrelease.ascode.service.{MetadataProcessor, ReleaseAsCodeService}
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec
import com.xebialabs.xlrelease.utils.FolderId
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class StartReleaseSpecInterpreter(releaseAsCodeService: ReleaseAsCodeService,
                                  metadataProcessor: MetadataProcessor) extends SpecInterpreter with Logging {
  override def isDefinedAt(config: InterpreterContext): Boolean = config.definition.spec.isInstanceOf[StartReleaseSpec]

  override def apply(config: InterpreterContext): AsCodeResponse = {
    val definition = config.definition
    implicit val metadata: Map[String, String] = metadataProcessor.processMetadata(definition.kind, definition.metadata)
    val startReleaseSpec = definition.spec.asInstanceOf[StartReleaseSpec]
    logger.debug(s"Kind ${definition.kind} found, initializing the following release: $startReleaseSpec")
    val release = releaseAsCodeService.startRelease(
      startReleaseSpec.templatePath,
      startReleaseSpec.releaseName,
      startReleaseSpec.variables,
      startReleaseSpec.autoStart,
      startReleaseSpec.riskProfile
    )
    val releaseId = release.getId
    AsCodeResponse.task(TaskInfo(
      FolderId(releaseId).path.drop(1),
      s"Release '${startReleaseSpec.releaseName}'",
      started = startReleaseSpec.autoStart
    ))
  }
}
