package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.xlrelease.api.v1.ApplicationApi
import com.xebialabs.xlrelease.ascode.service.GenerateService.GeneratorConfig
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.ascode.yaml.model.Application
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_APPLICATION
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
@Autowired
class ApplicationAsCodeService(applicationApi: ApplicationApi, permissions: PermissionChecker) {

  def generateApplications(generatorConfig: GeneratorConfig): List[Application] = {
    if (generatorConfig.cisConfig.generateApplications &&
      !generatorConfig.searchScope.isInstanceOf[FolderSearch] &&
      permissions.hasGlobalPermission(EDIT_APPLICATION)) {

      val applications = applicationApi.search(null)
      applications.asScala.toList
        .filter { app =>
          generatorConfig.name.forall { n => Utils.stringLike(app.getTitle, n) }
        }.map { app => Application(app.getTitle, app.getEnvironments.asScala.map(_.getTitle).toList) }
    } else {
      List.empty
    }
  }
}
