package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.repository.{FolderRepository, Ids}
import com.xebialabs.xlrelease.udm.reporting.filters.impl.FolderFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class FolderFilterGeneratorHandler @Autowired()(
                                                 folderRepository: FolderRepository
                                               ) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[FolderFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val folderFilter = ci.asInstanceOf[FolderFilter]
    try {
      Option(folderFilter.getFolderId)
        .map(folderId => Utils.joinPaths(folderRepository.getPath(folderId).tail))
        .foreach(folderId => folderFilter.setFolderId(FolderFilterGeneratorHandler.referencePath(folderId, ciWithHome.home)))
    } catch {
      case _ => throw new AsCodeException(s"FolderFilter with Folder id [${folderFilter.getFolderId}] was not found")
    }
  }
}

object FolderFilterGeneratorHandler {
  def referencePath(absolutePath: String, home: Option[String]): String = {
    if (absolutePath != null) {
      home.map(path => if (absolutePath.equals(path)) Ids.LOCAL_FOLDER
      else if (absolutePath.startsWith(path + Ids.SEPARATOR)) s"./${absolutePath.substring(path.length + 1)}"
      else absolutePath).getOrElse(absolutePath)
    }
    else absolutePath
  }
}