package com.xebialabs.xlrelease.ascode.service.validator
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec
import org.springframework.stereotype.Component

@Component
class StartReleaseSpecValidator extends SpecValidator {
  override def isDefinedAt(definition: Definition): Boolean = definition.spec.isInstanceOf[StartReleaseSpec]

  override def apply(definition: Definition): Unit = {
    val startReleaseSpec = definition.spec.asInstanceOf[StartReleaseSpec]
    val filteredReleases = startReleaseSpec.releaseName.startsWith("/") || startReleaseSpec.templatePath.startsWith("/")

    if (filteredReleases) {
      val wrongField = if (startReleaseSpec.templatePath.startsWith("/")) startReleaseSpec.templatePath else startReleaseSpec.releaseName

      throw new AsCodeException(s"The current definition is not valid. Some of the paths got an '/' at the beginning. The paths are: [$wrongField]")
    }
  }
}
