package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.xlrelease.ascode.yaml.parser.ValueTagPreprocessingConstructor
import org.yaml.snakeyaml.{LoaderOptions, TypeDescription, Yaml}

import scala.collection.mutable.ListBuffer

object YamlUtils {

  def preprocessYaml(yamlStr: String): List[String] = {
    val processedYamlStrs = ListBuffer.empty[String]
    val constructor = new ValueTagPreprocessingConstructor(new LoaderOptions)
    constructor.addTypeDescription(new TypeDescription(classOf[String], "!file"))
    val yamlParser = new Yaml(constructor)
    val data = yamlParser.loadAll(yamlStr)
    data.forEach { spec =>
      if (spec != null) {
        processedYamlStrs.addOne(yamlParser.dump(spec))
      }
    }

    processedYamlStrs.toList
  }
}
