package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.xlrelease.versioning.ascode.scm.VersioningStyle
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Component
class VersioningStrategyResolver @Autowired()(strategies: JList[VersioningStyleStrategy]) {

  lazy val supportedStyles: List[VersioningStyle] = strategies.asScala.sortBy(_.order).map(str => new VersioningStyle(str.name, str.value)).toList

  def resolve(style: String): VersioningStyleStrategy = strategies.asScala.filter(_.name.equals(style)).head

}
