package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.deployit.plugin.api.reflect.Type.valueOf
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.ascode.utils.Utils.filterFolderOnGeneratePermissions
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_FOLDER_CONFIGURATION
import com.xebialabs.xlrelease.service.SharedConfigurationService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.collection.immutable.ListMap
import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters._

@Component
class ConfigurationAsCodeGenerator @Autowired()(sharedConfigurationService: SharedConfigurationService,
                                                permissions: PermissionChecker) extends GenericGenerateStrategy {

  override val generateOrder: Double = 1

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateConfigurations
  }

  override protected def generateFolder(config: CiGenerateConfig): Map[Option[Folder], List[ConfigurationItem]] = {
    val configurations = config.folders
      .filter { folder => filterFolderOnGeneratePermissions(config, folder.getId) || permissions.hasPermission(EDIT_FOLDER_CONFIGURATION, folder.getId) }
      .map { folder =>
        val configs = ListBuffer.empty[ConfigurationItem]
        configs ++= sharedConfigurationService.searchByTypeAndTitle(valueOf(classOf[Configuration]), null, folder.getId, true).asScala
        Some(folder) -> configs.toList
      }

    ListMap(configurations: _*)
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[ConfigurationItem]] = {
    if (config.isAdminUser) {
      val configs = ListBuffer.empty[ConfigurationItem]
      // get global configurations only
      configs ++= sharedConfigurationService.searchByTypeAndTitle(valueOf(classOf[Configuration]), null, null, false).asScala
      ListMap(None -> configs.toList)
    } else {
      ListMap.empty
    }
  }
}
