package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.utils.Utils
import com.xebialabs.xlrelease.ascode.yaml.sugar.XLRSugar
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class CiReferenceCreationService @Autowired()(
                                               generators: java.util.List[CiReferenceCreationHandler]
                                             ) extends Logging {
  private val handlerFunction = generators.asScala.reduceLeft[PartialFunction[CiReferenceCreationConfig, Option[AnyRef]]]((left, right) => left.orElse(right))
    .orElse(new CiReferenceCreationHandler {
      override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = false

      override def apply(helper: CiReferenceCreationConfig): Option[AnyRef] = None
    })

  def createTypeSpecificReference(config: CiReferenceCreationConfig): Unit = {
    handlerFunction(config) match {
      case Some(reference) =>
        logger.debug(s"Setting reference property ${config.ci} to $reference")
        config.propertyDescriptor.set(config.ci, reference)
      case None => throw new AsCodeException(s"The reference with name [${config.reference.getIds.asScala.headOption.getOrElse("")}] in the field [${Utils.getSugaredField(config.propertyDescriptor, config.ci.getType, XLRSugar.config)}] should be created first before trying to use it.")
    }
  }
}
