package com.xebialabs.xlrelease.versioning.ascode.actors

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.scm.data.VersionInfo
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActor._
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorInitializer.FolderVersioningActorHolder
import grizzled.slf4j.Logging
import org.apache.pekko.util.Timeout
import org.springframework.stereotype.Component

import java.util.Date
import scala.concurrent.{Await, TimeoutException}

@Component
class FolderVersioningActorService(folderVersioningActorHolder: FolderVersioningActorHolder, xlrConfig: XlrConfig) extends Logging {

  def fetchChanges(folderId: String): (Date, Seq[VersionInfo]) = askAndAwait {
    FetchChanges(folderId)
  }

  def createVersion(folderId: String, version: String, description: String): VersionInfo = askAndAwait {
    CreateVersion(folderId, version, description)
  }

  def createOrUpdateSettings(config: FolderVersioningSettings): FolderVersioningSettings = askAndAwait {
    CreateOrUpdateSettings(config)
  }

  def cleanLocalRepo(folderId: String, clusterWide: Boolean): Unit = {
    folderVersioningActorHolder ! CleanLocalRepo(folderId, clusterWide)
  }

  def resetLocalRepo(settings: FolderVersioningSettings, clusterWide: Boolean): Unit = {
    folderVersioningActorHolder ! ResetLocalRepo(settings, clusterWide)
  }

  def clearSecrets(folderId: String): Unit = {
    folderVersioningActorHolder ! ClearSecrets(folderId)
  }

  private def askAndAwait[T](msg: AnyRef): T = {
    implicit val askTimeout: Timeout = xlrConfig.timeouts.releaseActionResponse
    try {
      Await.result(
        folderVersioningActorHolder ? msg,
        askTimeout.duration
      ).asInstanceOf[T]
    } catch {
      case e: TimeoutException => throw new RuntimeException(e)
      case e: InterruptedException => throw new RuntimeException(e)
    }
  }
}
