package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.api.v1.filter.{ApplicationEnvironmentFilterScope, ApplicationFilters}
import com.xebialabs.xlrelease.environments.service.ApplicationService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.ApplicationFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class ApplicationFilterStringReferenceCreationHandler(applicationService: ApplicationService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[ApplicationFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[ApplicationFilter]
    val appName = filter.getApplicationId
    val searchFilter = new ApplicationFilters(ApplicationEnvironmentFilterScope.ALL)
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("applicationId")

    searchFilter.setTitle(appName)


    val value = applicationService
      .searchApplications(searchFilter)
      .asScala
      .map(app => Ids.getName(app.getId))
      .headOption.getOrElse(throw new AsCodeException(s"Application with name $appName was not found. Please create it first before using it."))
    config.ci.setId("-1")

    StringReferenceContainer(filter, Map(descriptor -> Some(value)))
  }
}
