package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.DeliveryTaskStringReferenceCreationHandler.deliveryTaskType
import com.xebialabs.xlrelease.domain.CustomScriptTask
import com.xebialabs.xlrelease.dsl.resolver.{DeliveryTaskFromPathResolver, DeliveryTaskPathResolver}
import com.xebialabs.xlrelease.dsl.service.DslError
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.util.Failure

object DeliveryTaskStringReferenceCreationHandler {
  val deliveryTaskType = "delivery.Task"
}

@Component
class DeliveryTaskStringReferenceCreationHandler @Autowired()(val deliveryTaskFromPathResolver: DeliveryTaskFromPathResolver)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[CustomScriptTask] &&
    config.ci.asInstanceOf[CustomScriptTask].getTaskType.isSubTypeOf(Type.valueOf(deliveryTaskType))

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val deliveryTask = config.ci.asInstanceOf[CustomScriptTask].getPythonScript
    DeliveryTaskPathResolver.fieldsWithFolderPath.filter(deliveryTask.hasProperty(_)).foreach(
      folderField => deliveryTask.setProperty(folderField, FolderAsCodeService.absolutePath(deliveryTask.getProperty[String](folderField), config.home)))
    val resolutions = deliveryTaskFromPathResolver.resolve(deliveryTask)
    val resolvedValues = resolutions.map { case (property, change) =>
      val newValue = change.newValue.recoverWith {
        case e: DslError => Failure(new AsCodeException(e.getMessage))
        case e => Failure(new AsCodeException(e.getMessage, e))
      }.get
      (property, Option(newValue))
    }

    StringReferenceContainer(deliveryTask, resolvedValues)
  }

}
