package com.xebialabs.xlrelease.versioning.ascode.actors

import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ManagedActor}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActor.FolderVersioningCommand
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorInitializer.FolderVersioningActorHolder
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer
import com.xebialabs.xlrelease.versioning.ascode.scm.{FolderVersioningConfigService, FolderVersioningService}
import org.apache.pekko.actor.{Actor, ActorLogging, Props}
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.security.core.context.SecurityContextHolder

object FolderVersioningActorInitializer {
  type FolderVersioningActorHolder = ManagedActor[FolderVersioningActor]
}

@Configuration
class FolderVersioningActorInitializer(xlrConfig: XlrConfig,
                                       actorSystemHolder: ActorSystemHolder,
                                       folderVersioningService: FolderVersioningService,
                                       folderVersioningConfigService: FolderVersioningConfigService,
                                       connectorInitializer: AsCodeJGitConnectorInitializer) {
  @Bean
  def folderVersioningActorHolder(): FolderVersioningActorHolder = {
    val actorProps = if (xlrConfig.isClusterEnabled) {
      //TODO: Mix FolderVersioningActorAuthMixin with FolderVersioningActor in correct order and remove this. Use SpringExtension maybe?
      Props(new ClusteredFolderVersioningActor(folderVersioningService, connectorInitializer, folderVersioningConfigService) with FolderVersioningActorAuthMixin)
    } else {
      Props(new NonClusteredFolderVersioningActor(folderVersioningService, connectorInitializer, folderVersioningConfigService) with FolderVersioningActorAuthMixin)
    }
    actorSystemHolder.actorOf(actorProps, "folderVersioningActor")
  }
}

trait FolderVersioningActorAuthMixin extends Actor {
  this: ActorLogging =>
  abstract override def receive: Receive = {
    case cmd: FolderVersioningCommand =>
      val maybeAuthentication = cmd.callerContext
      log.debug(s"Setting caller as ${maybeAuthentication.map(_.getName)} for command $cmd")
      val newCtxt = SecurityContextHolder.createEmptyContext()
      newCtxt.setAuthentication(maybeAuthentication.orNull)
      SecurityContextHolder.setContext(newCtxt)
      try {
        super.aroundReceive(super.receive, cmd)
      } finally {
        SecurityContextHolder.clearContext()
      }
    case cmd =>
      super.aroundReceive(super.receive, cmd)
  }
}
