package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.{Spec, UsersSpec}
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.xlrelease.ascode.yaml.model.user.XLRUser

import scala.jdk.CollectionConverters._

object XLRUsersSpecParser extends SpecParser {
  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode
                    )(implicit mapper: ObjectMapper): Spec = {
    val users = node.elements().asScala.map { user =>
      val username = user.requiredString("username")
      val password = user.requiredString("password")
      val email = user.string("email")
      val name = user.string("name")
      val enabled = user.requiredBoolean("enabled")
      val dateFormat = user.string("dateFormat")
      val timeFormat = user.string("timeFormat")
      val firstDayOfWeek = user.string("firstDayOfWeek")
      XLRUser(username, password, name, email, enabled, dateFormat, timeFormat, firstDayOfWeek)
    }.toList
    UsersSpec(users)
  }
}
