package com.xebialabs.xlrelease.versioning.ascode.upgrader

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.service.FolderService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.utils.TypeHelper
import grizzled.slf4j.Logging
import org.codehaus.jettison.json.JSONObject
import org.springframework.stereotype.Component

import scala.util.{Failure, Try}

@Component
class XLRelease220FolderVersioningTagPrefixUpgrade(configurationRepository: ConfigurationRepository,
                                                   configurationPersistence: ConfigurationPersistence,
                                                   folderService: FolderService,
                                                   sqlRepositoryAdapter: SqlRepositoryAdapter) extends Upgrade with Logging {

  private val ciType = Type.valueOf(classOf[FolderVersioningSettings])

  def upgradeFolderVersioningSettings(): Unit = {

    val folderVersioningSettingsConfigRow = configurationPersistence.findByTypes(
      TypeHelper.getAllSubtypesOf(ciType).map(_.toString))
    if (folderVersioningSettingsConfigRow.nonEmpty) {
      logger.info("Found Version control configuration for upgrade")
      folderVersioningSettingsConfigRow.map(configurationRow => (configurationRow._1, new JSONObject(configurationRow._2))).
        filter(_._2.has("tagPrefix")).foreach(config => {
        val folderVersionJson = config._2
        val tagPrefix = folderVersionJson.getString("tagPrefix")
        folderVersionJson.remove("tagPrefix")
        val folderVersioningSettings = sqlRepositoryAdapter.readConfiguration[FolderVersioningSettings]((config._1, folderVersionJson.toString))
        folderVersioningSettings.foreach(versioningSetting => {
          if (!versioningSetting.getEffectiveTagPrefix.equals(tagPrefix)) {
            val folderName = scala.util.Try(folderService.getTitle(versioningSetting.getFolderId)).getOrElse("")
            logger.info(s"Version Control Tag Prefix property for folder $folderName normalized from $tagPrefix to ${versioningSetting.getEffectiveTagPrefix}")
          }
          configurationRepository.update[FolderVersioningSettings](versioningSetting)
        })


      })

    }

  }

  override def doUpgrade(): Boolean = {
    Try(upgradeFolderVersioningSettings()) match {
      case Failure(_) => logger.error("Unable to upgrade Version Control configuration")
      case _ =>
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#1")

}
