package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.xlrelease.ascode.yaml.model.StartReleaseSpec

object StartReleaseParser extends SpecParser {
  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val releaseName = node.requiredString("name")
    val templatePath = node.requiredString("template")
    val variables = node.mapStringAnyRef("variables")
    val autoStart = node.property("autoStart").forall(_.asBoolean(true))
    val riskProfile = node.string("riskProfile")

    StartReleaseSpec(releaseName, templatePath, riskProfile, variables, autoStart)
  }
}
