package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.environments.service.EnvironmentLabelService
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.XLReleasePermissions.EDIT_ENVIRONMENT
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import com.xebialabs.xlrelease.ascode.utils.Utils

import scala.jdk.CollectionConverters._

@Component
class EnvironmentLabelAsCodeGenerator @Autowired()(environmentLabelService: EnvironmentLabelService,
                                                   permissions: PermissionChecker) extends ApplicationEnvironmentGenerateStrategy[EnvironmentLabel] {
  override val generateOrder: Double = 300

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateEnvironments
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[EnvironmentLabel]] = {
    if (config.isAdminUser || permissions.hasGlobalPermission(EDIT_ENVIRONMENT)) {
      val labels = environmentLabelService.searchLabels(new EnvironmentLabelFilters).asScala.toList
        .filter { ci =>
          config.ciTitle.forall { n => Utils.stringLike(ci.getTitle, n) }
        }
      Map(None -> labels)
    } else {
      Map.empty
    }
  }

}
