package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.scm.connector.ScmBlobs

trait VersioningStyleStrategy {

  def generateFolder(folderId: String, settings: FolderVersioningSettings): FolderContent

  def getVersionableFileNames(folderId: String, folderVersioningSettings: FolderVersioningSettings): List[String]

  def name: String

  def value: String

  def order: Integer

}

case class FolderContent(blob: ScmBlobs, definitions: List[Definition], secrets: Map[String, String])