package com.xebialabs.xlrelease.ascode.service.spec

import com.xebialabs.ascode.service.spec.{InterpreterContext, SpecInterpreter}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.ascode.yaml.model.UsersSpec
import com.xebialabs.xlrelease.ascode.service.UsersAsCodeService
import com.xebialabs.xlrelease.ascode.yaml.model.user.XLRUser
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class UsersSpecInterpreter(usersAsCodeService: UsersAsCodeService) extends SpecInterpreter {
  override def isDefinedAt(context: InterpreterContext): Boolean = context.definition.spec.isInstanceOf[UsersSpec]

  override def apply(context: InterpreterContext): AsCodeResponse = {
    val usersSpec = context.definition.spec.asInstanceOf[UsersSpec]
    AsCodeResponse.ids(usersSpec.users.foldLeft(USER.ids) { (acc, user) =>
      acc.merge(usersAsCodeService.handleUser(user.asInstanceOf[XLRUser]))
    })
  }
}
