package com.xebialabs.xlrelease.versioning.ascode.repository

import com.xebialabs.xlrelease.domain.id.CiUid
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReportMessage

trait FolderValidationMessageRepository {
  def findValidationMessageById(messageId: CiUid): Option[ValidationReportMessage]

  def findValidationMessagesByFolderId(folderId: String): Seq[ValidationReportMessage]

  def updateValidationMessageResolvedState(messageId: CiUid, validationMessage: ValidationReportMessage): Unit

  def createValidationMessageEntity(folderId: String, validationMessage: ValidationReportMessage): Unit

  def deleteValidationMessage(messageId: CiUid): Unit
}
