package com.xebialabs.xlrelease.ascode.yaml.parser.util

import com.xebialabs.ascode.yaml.parser.util.FieldBlacklisting
import com.xebialabs.xlrelease.ascode.utils.Utils

class XLRFieldBlacklisting extends FieldBlacklisting {

  override val prohibitedProperties: Map[String, List[String]] = Map(
    "xlrelease.Release" -> List("status", "scmConnectorConfig")
  )

  override protected def isNotAllowed(fieldName: String, nodeType: String): Boolean = {
    if(!Utils.isTypeAPythonScript(nodeType)) {
      super.isNotAllowed(fieldName, nodeType)
    } else {
      super.isNotAllowed(fieldName, nodeType) && super.isNotAllowed(fieldName, "xlrelease.CustomScriptTask")
    }
  }
}
