package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.deployit.security.PermissionEnforcer.ROLE_ADMIN
import com.xebialabs.xlrelease.authentication.AuthenticationSupport
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logger
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken
import org.springframework.security.core.authority.SimpleGrantedAuthority

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

trait FolderVersionApplyHelper extends AuthenticationSupport {

  protected def logger: Logger

  def folderVersioningService: FolderVersioningService

  def fetchAndApplyLatestVersion(folderId: String, folderName: String): Boolean = {
    Try {
      logger.trace(s"Trying to get latest version changes for folder '$folderName'")
      // This SHOULD NOT be used anywhere else. This is only for upgrades and quartz job to run as admin.
      val adminUserTokenForUpgrade = new UsernamePasswordAuthenticationToken(User.SYSTEM, "", Seq(new SimpleGrantedAuthority(ROLE_ADMIN)).asJava)
      withAuthentication(adminUserTokenForUpgrade) {
        val folderVersioningSettings = folderVersioningService.getSettings(folderId)
        val existingAppliedVersion = folderVersioningSettings.appliedVersion
        val (_, versions) = folderVersioningService.fetchChanges(folderId)
        versions.headOption.map(_.name).foreach { version =>
          if (existingAppliedVersion != version) {
            logger.info(s"Existing version is '$existingAppliedVersion' for folder '$folderName'. Importing a new version '$version'.")
            folderVersioningService.applyVersion(folderId, version)
          } else {
            logger.trace(s"Version '$version' for folder '$folderName' is already applied")
          }
        }
      }
    } match {
      case Failure(e) =>
        logger.error(s"Unable to apply version for folder '$folderName'. Reason: ${e.getMessage}")
        false
      case Success(_) =>
        true
    }
  }
}
