package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.FolderRepository
import com.xebialabs.xlrelease.variable.VariableHelper
import org.springframework.stereotype.Component

import scala.util.Try

@Component
class TemplateGeneratorHandler(folderRepository: FolderRepository) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[Release]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val template = ci.asInstanceOf[Release]

    Try {
      Option(template.getDefaultTargetFolderId)
        .filterNot(VariableHelper.containsVariables)
        .map(defaultTargetFolderId => FolderFilterGeneratorHandler.referencePath(Utils.joinPaths(folderRepository.getPath(defaultTargetFolderId).tail), ciWithHome.home))
    }.recover {
      case _: Exception => Some(null)
    }.toOption.flatten.foreach(template.setDefaultTargetFolderId)
  }
}
