package com.xebialabs.xlrelease.versioning.ascode.actors

import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ManagedActor}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorInitializer.FolderVersioningActorHolder
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnectorInitializer
import com.xebialabs.xlrelease.versioning.ascode.scm.{FolderVersioningConfigService, FolderVersioningService}
import org.apache.pekko.actor.Props
import org.springframework.context.annotation.{Bean, Configuration}

object FolderVersioningActorInitializer {
  type FolderVersioningActorHolder = ManagedActor[FolderVersioningActor]
}

@Configuration
class FolderVersioningActorInitializer(xlrConfig: XlrConfig,
                                       actorSystemHolder: ActorSystemHolder,
                                       folderVersioningService: FolderVersioningService,
                                       folderVersioningConfigService: FolderVersioningConfigService,
                                       connectorInitializer: AsCodeJGitConnectorInitializer) {
  @Bean
  def folderVersioningActorHolder(): FolderVersioningActorHolder = {
    val actorProps = if (xlrConfig.isClusterEnabled) {
      Props(new ClusteredFolderVersioningActor(folderVersioningService, connectorInitializer, folderVersioningConfigService))
    } else {
      Props(new NonClusteredFolderVersioningActor(folderVersioningService, connectorInitializer, folderVersioningConfigService))
    }
    actorSystemHolder.actorOf(actorProps, "folderVersioningActor")
  }
}

