/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings;
import com.xebialabs.xlrelease.scm.data.VersionInfo;
import com.xebialabs.xlrelease.scm.data.VersionsView;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.form.CreateVersionForm;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReport;
import com.xebialabs.xlrelease.versioning.ascode.form.ValidationReportMessage;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.VersioningStyle;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Path(value="api/v1/folders/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001B\r\u001b\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005OAqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003\\\u0001!\tA!\u0018\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BQ\u0001\u0011\u0005!1\u0015\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007DqAa8\u0001\t\u0003\u0011\t\u000fC\u0004\u0003x\u0002!\tA!?\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n\tAbi\u001c7eKJ4VM]:j_:Lgn\u001a*fg>,(oY3\u000b\u0005ma\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005uq\u0012aA1qS*\u0011q\u0004I\u0001\nq2\u0014X\r\\3bg\u0016T!!\t\u0012\u0002\u0013a,'-[1mC\n\u001c(\"A\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQa\u001d7gi)T\u0011!M\u0001\tOJL'P\u001f7fI&\u00111G\f\u0002\b\u0019><w-\u001b8h\u0003E\u0001XM]7jgNLwN\\\"iK\u000e\\WM\u001d\t\u0003mej\u0011a\u000e\u0006\u0003qy\t\u0001b]3dkJLG/_\u0005\u0003u]\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003]1w\u000e\u001c3feZ+'o]5p]&twmU3sm&\u001cW\r\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006\u00191oY7\u000b\u0005\u0005\u0013\u0015AB1tG>$WM\u0003\u0002D=\u0005Qa/\u001a:tS>t\u0017N\\4\n\u0005\u0015s$a\u0006$pY\u0012,'OV3sg&|g.\u001b8h'\u0016\u0014h/[2f\u00039\u0001(/\u001a<jK^\u001cVM\u001d<jG\u0016\u0004\"!\u0010%\n\u0005%s$A\b$pY\u0012,'OV3sg&|g.\u001b8h!J,g/[3x'\u0016\u0014h/[2f\u0003q1w\u000e\u001c3feZ+'o]5p]&tw-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001T(\u000e\u00035S!A\u0014!\u0002\r\u0005\u001cGo\u001c:t\u0013\t\u0001VJ\u0001\u000fG_2$WM\u001d,feNLwN\\5oO\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015\u0019VKV,Y!\t!\u0006!D\u0001\u001b\u0011\u0015!T\u00011\u00016\u0011\u0015YT\u00011\u0001=\u0011\u00151U\u00011\u0001H\u0011\u0015QU\u00011\u0001LQ\t)!\f\u0005\u0002\\M6\tAL\u0003\u0002^=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005}\u0003\u0017a\u00024bGR|'/\u001f\u0006\u0003C\n\fQAY3b]NT!a\u00193\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Z\u0001\u0004_J<\u0017BA4]\u0005%\tU\u000f^8xSJ,G-A\u0006hKR\u001cV\r\u001e;j]\u001e\u001cHC\u00016s!\tY\u0007/D\u0001m\u0015\t\tUN\u0003\u0002D]*\u0011qNH\u0001\u0007I>l\u0017-\u001b8\n\u0005Ed'\u0001\u0007$pY\u0012,'OV3sg&|g.\u001b8h'\u0016$H/\u001b8hg\")1O\u0002a\u0001i\u0006Aam\u001c7eKJLE\r\u0005\u0002vy:\u0011aO\u001f\t\u0003o\"j\u0011\u0001\u001f\u0006\u0003s\u0012\na\u0001\u0010:p_Rt\u0014BA>)\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mD\u0003f\u0002:\u0002\u0002\u0005U\u0011q\u0003\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\t\u00118O\u0003\u0003\u0002\f\u00055\u0011AA<t\u0015\t\ty!A\u0004kC.\f'\u000f^1\n\t\u0005M\u0011Q\u0001\u0002\n!\u0006$\b\u000eU1sC6\fQA^1mk\u0016\f\u0013a\u001d\u0015\u0004\r\u0005m\u0001\u0003BA\u0002\u0003;IA!a\b\u0002\u0006\t\u0019q)\u0012+)\u000f\u0019\t\u0019#!\u0006\u0002*A!\u00111AA\u0013\u0013\u0011\t9#!\u0002\u0003\tA\u000bG\u000f[\u0011\u0003\u0003W\t1dL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|\u0013AD;qI\u0006$XmU3ui&twm\u001d\u000b\u0006U\u0006E\u0012Q\u0007\u0005\u0006g\u001e\u0001\r\u0001\u001e\u0015\t\u0003c\t\t!!\u0006\u0002\u0018!1\u0011qG\u0004A\u0002)\faaY8oM&<\u0007fA\u0004\u0002<A!\u00111AA\u001f\u0013\u0011\ty$!\u0002\u0003\u0007A+F\u000bK\u0004\b\u0003G\t)\"!\u000b\u0002\u001d\u0011,G.\u001a;f'\u0016$H/\u001b8hgR!\u0011qIA'!\r9\u0013\u0011J\u0005\u0004\u0003\u0017B#\u0001B+oSRDQa\u001d\u0005A\u0002QD\u0003\"!\u0014\u0002\u0002\u0005U\u0011q\u0003\u0015\u0004\u0011\u0005M\u0003\u0003BA\u0002\u0003+JA!a\u0016\u0002\u0006\t1A)\u0012'F)\u0016Cs\u0001CA\u0012\u0003+\tI#A\u0006hKR4VM]:j_:\u001cHCBA0\u0003[\n\t\b\u0005\u0003\u0002b\u0005%TBAA2\u0015\u0011\t)'a\u001a\u0002\t\u0011\fG/\u0019\u0006\u0003\u007fyIA!a\u001b\u0002d\taa+\u001a:tS>t7OV5fo\")1/\u0003a\u0001i\"B\u0011QNA\u0001\u0003+\t9\u0002C\u0004\u0002t%\u0001\r!!\u001e\u0002\u0019\u0019,Go\u00195DQ\u0006tw-Z:\u0011\u0007\u001d\n9(C\u0002\u0002z!\u0012qAQ8pY\u0016\fg\u000e\u000b\u0005\u0002r\u0005u\u0014QCAB!\u0011\t\u0019!a \n\t\u0005\u0005\u0015Q\u0001\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0003\u0003\u000b\u000bQAZ1mg\u0016D\u0003\"!\u001d\u0002\n\u0006U\u0011q\u0012\t\u0005\u0003\u0007\tY)\u0003\u0003\u0002\u000e\u0006\u0015!AC)vKJL\b+\u0019:b[\u0006\u0012\u00111\u000f\u0015\u0004\u0013\u0005m\u0001fB\u0005\u0002$\u0005U\u0011QS\u0011\u0003\u0003/\u000b1eL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u001a:tS>t7/A\u0007de\u0016\fG/\u001a,feNLwN\u001c\u000b\u0007\u0003;\u000b\u0019+a*\u0011\t\u0005\u0005\u0014qT\u0005\u0005\u0003C\u000b\u0019GA\u0006WKJ\u001c\u0018n\u001c8J]\u001a|\u0007\"B:\u000b\u0001\u0004!\b\u0006CAR\u0003\u0003\t)\"a\u0006\t\u000f\u0005%&\u00021\u0001\u0002,\u0006Ya/\u001a:tS>tgi\u001c:n!\u0011\ti+a-\u000e\u0005\u0005=&bAAY\u0001\u0006!am\u001c:n\u0013\u0011\t),a,\u0003#\r\u0013X-\u0019;f-\u0016\u00148/[8o\r>\u0014X\u000eK\u0002\u000b\u0003s\u0003B!a\u0001\u0002<&!\u0011QXA\u0003\u0005\u0011\u0001vj\u0015+)\u000f)\t\u0019#!\u0006\u0002\u0016\u0006a\u0011\r\u001d9msZ+'o]5p]R1\u0011qIAc\u0003\u0013DQa]\u0006A\u0002QD\u0003\"!2\u0002\u0002\u0005U\u0011q\u0003\u0005\u0007\u0003\u0017\\\u0001\u0019\u0001;\u0002\u000fY,'o]5p]\"B\u0011\u0011ZA\u0001\u0003+\ty-\t\u0002\u0002L\"\u001a1\"!/)\u000f-\t\u0019#!\u0006\u0002V\u0006\u0012\u0011q[\u00017_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wKJ\u001c\u0018n\u001c8t_m4XM]:j_:TdFK?0CB\u0004H._\u0001\u000faJ,g/[3x\u0007V\u0014(/\u001a8u)\u0015!\u0018Q\\Aq\u0011\u0015\u0019H\u00021\u0001uQ!\ti.!\u0001\u0002\u0016\u0005]\u0001BBAr\u0019\u0001\u0007A/\u0001\u0005gS2,g.Y7fQ\u0011\t\t/a:\u0011\t\u0005\r\u0011\u0011^\u0005\u0005\u0003W\f)AA\u0004F]\u000e|G-\u001a3)\u0011\u0005\u0005\u0018\u0011RA\u000b\u0003_\f#!a9)\u00071\tY\u0002K\u0004\r\u0003k\f)\"a?\u0011\t\u0005\r\u0011q_\u0005\u0005\u0003s\f)A\u0001\u0005Qe>$WoY3tY\t\ti0\t\u0002\u0002\u0000\u0006iA/\u001a=u_YtGML=b[2Ds\u0001DA\u0012\u0003+\u0011\u0019!\t\u0002\u0003\u0006\u0005\u0011sf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>\u0002(/\u001a<jK^\fa\u0002\u001d:fm&,wOV3sg&|g\u000eF\u0004u\u0005\u0017\u0011yAa\u0005\t\u000bMl\u0001\u0019\u0001;)\u0011\t-\u0011\u0011AA\u000b\u0003/Aa!a3\u000e\u0001\u0004!\b\u0006\u0003B\b\u0003\u0003\t)\"a4\t\r\u0005\rX\u00021\u0001uQ\u0011\u0011\u0019\"a:)\u0011\tM\u0011\u0011RA\u000b\u0003_D3!DA\u000eQ\u001di\u0011Q_A\u000b\u0005;a#!!@)\u000f5\t\u0019#!\u0006\u0003\"\u0005\u0012!1E\u00019_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018wKJ\u001c\u0018n\u001c8t_m4XM]:j_:TdFK?0aJ,g/[3x\u0003U9W\r\u001e,feNLwN\\3e\r&dWMT1nKN$bA!\u000b\u0003<\t}\u0002#\u0002B\u0016\u0005k!h\u0002\u0002B\u0017\u0005cq1a\u001eB\u0018\u0013\u0005I\u0013b\u0001B\u001aQ\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u001c\u0005s\u0011A\u0001T5ti*\u0019!1\u0007\u0015\t\u000bMt\u0001\u0019\u0001;)\u0011\tm\u0012\u0011AA\u000b\u0003/Aa!a3\u000f\u0001\u0004!\b\u0006\u0003B \u0003\u0003\t)\"a4)\u00079\tY\u0002K\u0004\u000f\u0003G\t)Ba\u0012\"\u0005\t%\u0013AR\u0018|M>dG-\u001a:JIjr#FR8mI\u0016\u00148LX\u0018.;*jxF^3sg&|gn]\u0018|m\u0016\u00148/[8ou9RSpL4fiZ+'o]5p]\u0016$g)\u001b7f\u001d\u0006lWm]\u0001\u001fO\u0016$8)\u001e:sK:$h+\u001a:tS>t\u0017M\u00197f\r&dWMT1nKN$BA!\u000b\u0003P!)1o\u0004a\u0001i\"B!qJA\u0001\u0003+\t9\u0002K\u0002\u0010\u00037AsaDA\u0012\u0003+\u00119&\t\u0002\u0003Z\u0005\u0011tf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>:W\r\u001e,feNLwN\\1cY\u00164\u0015\u000e\\3OC6,7/A\beK2,G/\u001a'pG\u0006d'+\u001a9p)\u0019\t9Ea\u0018\u0003d!)1\u000f\u0005a\u0001i\"B!qLA\u0001\u0003+\t9\u0002C\u0004\u0003fA\u0001\r!!\u001e\u0002\u0017\rdWo\u001d;fe^KG-\u001a\u0015\t\u0005G\ni(!\u0006\u0002\u0004\"B!1MAE\u0003+\u0011Y'\t\u0002\u0003f!\u001a\u0001#a\u0015)\u000fA\t\u0019#!\u0006\u0003r\u0005\u0012!1O\u0001-_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018eK2,G/Z\u0017m_\u000e\fG.\f:fa>\faB]3tKRdunY1m%\u0016\u0004x\u000e\u0006\u0004\u0002H\te$Q\u0010\u0005\u0006gF\u0001\r\u0001\u001e\u0015\t\u0005s\n\t!!\u0006\u0002\u0018!9!QM\tA\u0002\u0005U\u0004\u0006\u0003B?\u0003{\n)\"a!)\u0011\tu\u0014\u0011RA\u000b\u0005WB3!EA\u001eQ\u001d\t\u00121EA\u000b\u0005\u000f\u000b#A!#\u0002W=Zhm\u001c7eKJLEM\u000f\u0018+\r>dG-\u001a:\\=>jSLK?0e\u0016\u001cX\r^\u0017m_\u000e\fG.\f:fa>\fqB^1mS\u0012\fG/Z\"veJ,g\u000e\u001e\u000b\u0005\u0005\u001f\u0013)\n\u0005\u0003\u0002.\nE\u0015\u0002\u0002BJ\u0003_\u0013\u0001CV1mS\u0012\fG/[8o%\u0016\u0004xN\u001d;\t\u000bM\u0014\u0002\u0019\u0001;)\u0011\tU\u0015\u0011AA\u000b\u0003/A3AEA\u000eQ\u001d\u0011\u00121EA\u000b\u0005;\u000b#Aa(\u0002G=Zhm\u001c7eKJLEM\u000f\u0018+\r>dG-\u001a:\\=>jSLK?0m\u0006d\u0017\u000eZ1uK\u0006)r-\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016\u001cH\u0003\u0002BH\u0005KCQa]\nA\u0002QD\u0003B!*\u0002\u0002\u0005U\u0011q\u0003\u0015\u0004'\u0005m\u0001fB\n\u0002$\u0005U!QV\u0011\u0003\u0005_\u000bafL>g_2$WM]%eu9Rci\u001c7eKJ\\flL\u0017^Uu|c/\u00197jI\u0006$\u0018n\u001c8.[\u0016\u001c8/Y4fg\u0006)2/\u001a;WC2LG-\u0019;j_:lUm]:bO\u0016\u001cHCBA$\u0005k\u0013I\fC\u0003t)\u0001\u0007A\u000f\u000b\u0005\u00036\u0006\u0005\u0011QCA\f\u0011\u001d\u0011Y\f\u0006a\u0001\u0005\u001f\u000b\u0001C^1mS\u0012\fG/[8o%\u0016\u0004xN\u001d;)\u0007Q\tY\u0004K\u0004\u0015\u0003G\t)B!,\u0002)\u001d,GOV1mS\u0012\fG/[8o\u001b\u0016\u001c8/Y4f)\u0019\u0011)Ma3\u0003PB!\u0011Q\u0016Bd\u0013\u0011\u0011I-a,\u0003/Y\u000bG.\u001b3bi&|gNU3q_J$X*Z:tC\u001e,\u0007\"B:\u0016\u0001\u0004!\b\u0006\u0003Bf\u0003\u0003\t)\"a\u0006\t\r\tEW\u00031\u0001u\u0003%iWm]:bO\u0016LE\r\u000b\u0005\u0003P\u0006\u0005\u0011Q\u0003BkC\t\u0011\t\u000eK\u0002\u0016\u00037As!FA\u0012\u0003+\u0011Y.\t\u0002\u0003^\u0006\u0011tf\u001f4pY\u0012,'/\u00133;])2u\u000e\u001c3fensv&L/+{>jWm]:bO\u0016|30\\3tg\u0006<W-\u00133;])jx&A\u000etKR4\u0016\r\\5eCRLwN\\'fgN\fw-Z:Ti\u0006$Xo\u001d\u000b\t\u0003\u000f\u0012\u0019Oa:\u0003l\")1O\u0006a\u0001i\"B!1]A\u0001\u0003+\t9\u0002\u0003\u0004\u0003RZ\u0001\r\u0001\u001e\u0015\t\u0005O\f\t!!\u0006\u0003V\"9!Q\u001e\fA\u0002\t\u0015\u0017!\u0005<bY&$\u0017\r^5p]6+7o]1hK\"\u001aa#a\u000f)\u000fY\t\u0019#!\u0006\u0003t\u0006\u0012!Q_\u00019_m4w\u000e\u001c3fe&#'H\f\u0016G_2$WM].__5j&&`\u0018nKN\u001c\u0018mZ30w6,7o]1hK&#'H\f\u0016~_U\u0004H-\u0019;f\u00031\u0019G.Z1s'\u0016\u001c'/\u001a;t)\u0011\t9Ea?\t\u000bM<\u0002\u0019\u0001;)\u0011\tm\u0018\u0011AA\u000b\u0003/A3aFA*Q\u001d9\u00121EA\u000b\u0007\u0007\t#a!\u0002\u0002Q=Zhm\u001c7eKJLEM\u000f\u0018+\r>dG-\u001a:\\=>jSLK?0G2,\u0017M]\u0017tK\u000e\u0014X\r^:\u0002'\u001d,GOV3sg&|g.\u001b8h'RLH.Z:\u0016\u0005\r-\u0001C\u0002B\u0016\u0005k\u0019i\u0001E\u0002>\u0007\u001fI1a!\u0005?\u0005=1VM]:j_:LgnZ*us2,\u0007f\u0001\r\u0002\u001c!:\u0001$a\t\u0002\u0016\r]\u0011EAB\r\u0003\u001dy3\u000f^=mKNDs\u0001AA\u0012\u0003+\u0019i\"\t\u0002\u0004 \u0005I\u0012\r]50mFzcm\u001c7eKJ\u001cxF^3sg&|g.\u001b8hQ\u001d\u0001\u0011Q_A\u000b\u0007Ga#a!\n\"\u0005\r\u001d\u0012\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u001d\u000111FA\u000b\u0007c\u0001B!a\u0001\u0004.%!1qFA\u0003\u0005!\u0019uN\\:v[\u0016\u001cHFAB\u0013Q\r\u00011Q\u0007\t\u0005\u0007o\u0019i$\u0004\u0002\u0004:)\u001911\b2\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0004@\re\"AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class FolderVersioningResource
implements Logging {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVersioningResource folderVersioningResource = this;
        synchronized (folderVersioningResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)((Object)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        config.setFolderId(folderId);
        return this.folderVersioningActorService.createOrUpdateSettings(config);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/")
    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionsView getVersions(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="fetchChanges") boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = fetchChanges ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions")
    public VersionInfo createVersion(@PathParam(value="folderId") String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.name(), versionForm.description());
    }

    @POST
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/apply")
    public void applyVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        this.folderVersioningService.applyVersion(folderId, version);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/preview")
    public String previewCurrent(@PathParam(value="folderId") String folderId, @Encoded @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, filename);
    }

    @GET
    @Produces(value={"text/vnd.yaml"})
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/preview")
    public String previewVersion(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version, @Encoded @QueryParam(value="filename") String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/versions/{version:.*}/getVersionedFileNames")
    public List<String> getVersionedFileNames(@PathParam(value="folderId") String folderId, @PathParam(value="version") String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionedFileNames(folderId, version);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/getVersionableFileNames")
    public List<String> getCurrentVersionableFileNames(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getVersionableFileNames(folderId);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/delete-local-repo")
    public void deleteLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, clusterWide);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/reset-local-repo")
    public void resetLocalRepo(@PathParam(value="folderId") String folderId, @DefaultValue(value="false") @QueryParam(value="clusterWide") boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, clusterWide);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validate")
    public ValidationReport validateCurrent(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public ValidationReport getValidationMessages(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/validation-messages")
    public void setValidationMessages(@PathParam(value="folderId") String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.warnings()).asScala().toSeq());
    }

    @GET
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/")
    public ValidationReportMessage getValidationMessage(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))));
    }

    @PUT
    @Path(value="/{folderId:.*Folder[^/-]*}/message/{messageId:.*}/update")
    public void setValidationMessagesStatus(@PathParam(value="folderId") String folderId, @PathParam(value="messageId") String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    @DELETE
    @Path(value="/{folderId:.*Folder[^/-]*}/clear-secrets")
    public void clearSecrets(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    @GET
    @Path(value="/styles")
    public List<VersioningStyle> getVersioningStyles() {
        return this.folderVersioningService.getVersioningStyles();
    }

    @Autowired
    public FolderVersioningResource(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        Logging.$init$((Logging)this);
    }
}

