package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.api.v1.TenantApi
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.configuration.TenantLimit
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.repository.CiCloneHelper
import org.springframework.stereotype.Component

import scala.collection.immutable.ListMap
import scala.jdk.CollectionConverters._

@Component
class TenantLimitAsCodeGenerator(tenantApi: TenantApi) extends GenerateStrategy[TenantLimit] {

  override val generateOrder: Double = 150

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateSettings
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[TenantLimit]] = {
    val limits = tenantApi.getLimits
    // Clone operation is required here because
    // limits are cached and updates on limit object done in TenantLimitGeneratorHandler will update the cached object
    val clonedLimits = CiCloneHelper.cloneCis(limits).asScala.toList
    ListMap(None -> clonedLimits)
  }

  override protected def filter(results: Map[Option[Folder], List[TenantLimit]], ciTitle: String): Map[Option[Folder], List[TenantLimit]] = {
    results.map { case (maybeFolder, cis) =>
      maybeFolder -> cis.filter { ci =>
        Utils.stringLike(ci.getType.toString, ciTitle)
      }
    }
  }
}
