package com.xebialabs.xlrelease.versioning.ascode.repository

import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage

trait FolderValidationMessageRepository {
  def findValidationMessageById(messageId: Integer): Option[ValidationReportMessage]

  def findValidationMessagesByFolderId(folderId: String): Seq[ValidationReportMessage]

  def updateValidationMessageResolvedState(messageId: Integer, validationMessage: ValidationReportMessage): Unit

  def createValidationMessageEntity(folderId: String, validationMessage: ValidationReportMessage): Unit

  def deleteValidationMessage(messageId: Integer): Unit
}
