package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.FolderExportConfig
import com.xebialabs.xlrelease.domain.FolderExportConfig.validateAndNormalize

class FolderExportConfigBuilder(folderId: String) {

  private val config = new FolderExportConfig()
  config.folderId = folderId

  def withNamesMatching(nameFilter: String): FolderExportConfigBuilder = {
    config.nameFilter = nameFilter
    this
  }

  def withConfigurations(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.configurations = enabled
    this
  }

  def withDashboards(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.dashboards = enabled
    this
  }

  def withDeliveryPatterns(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.deliveryPatterns = enabled
    this
  }

  def withNotifications(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.notifications = enabled
    this
  }

  def withPermissions(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.permissions = enabled
    this
  }

  def withTemplates(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.templates = enabled
    this
  }

  def withWorkflows(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.workflows = enabled
    this
  }

  def withTriggers(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.triggers = enabled
    this
  }

  def withVariables(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.variables = enabled
    this
  }

  def withApplications(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.applications = enabled
    this
  }

  def withEnvironments(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeKinds.environments = enabled
    this
  }

  def withAllKinds(enabled: Boolean): FolderExportConfigBuilder = {
    withConfigurations(enabled)
    withDashboards(enabled)
    withDeliveryPatterns(enabled)
    withNotifications(enabled)
    withPermissions(enabled)
    withTemplates(enabled)
    withWorkflows(enabled)
    withTriggers(enabled)
    withVariables(enabled)
    withApplications(enabled)
    withEnvironments(enabled)
  }

  def withSubFolders(enabled: Boolean): FolderExportConfigBuilder = {
    config.includeSubFolders = enabled
    this
  }

  def includeTemplateId(id: String): FolderExportConfigBuilder = {
    config.includeEntities.add(id)
    this
  }

  def excludeTemplateId(id: String): FolderExportConfigBuilder = {
    config.excludeEntities.add(id)
    this
  }

  def build(): FolderExportConfig = {
    validateAndNormalize(config)
    config
  }
}
