package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.xlrelease.ascode.yaml.model.{Environment, EnvironmentsSpec, Label, Reservation}

import scala.jdk.CollectionConverters._

object EnvironmentsSpecParser extends SpecParser {

  override def parse(definitionKind: String,
                     metadata: Option[Map[String, String]],
                     node: JsonNode)(implicit mapper: ObjectMapper): Spec = {
    val stages = node.listOfStrings("stages")
    val labels = node.property("labels").toList.flatMap(_.elements().asScala.map(parseLabel))
    val environments = node.property("environments").toList.flatMap(_.elements().asScala.map(parseEnvironments))
    val reservations = node.property("reservations").toList.flatMap(_.elements().asScala).map(parseEnvironmentReservations)
    EnvironmentsSpec(stages, labels, environments, reservations)
  }

  private def parseLabel(node: JsonNode) = {
    val name = node.requiredString("name")
    val color = node.requiredString("color")
    Label(name, color)
  }

  private def parseEnvironments(node: JsonNode) = {
    val name = node.requiredString("name")
    val description = node.string("description")
    val stage = node.requiredString("stage")
    val labels = node.listOfStrings("labels")
    Environment(name, description, stage, labels)
  }

  private def parseEnvironmentReservations(node: JsonNode): Reservation = {
    val environment = node.requiredString("environment")
    val apps = node.listOfStrings("applications")
    val startDate = node.requiredString("startDate")
    val endDate = node.requiredString("endDate")
    val note = node.string("note").orNull
    Reservation(environment, apps, startDate, endDate, note)
  }
}
