/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.FolderVersioningApi;
import com.xebialabs.xlrelease.api.v1.form.CreateVersionForm;
import com.xebialabs.xlrelease.api.v1.views.VersionInfo;
import com.xebialabs.xlrelease.api.v1.views.VersionsView;
import com.xebialabs.xlrelease.domain.utils.ScmException;
import com.xebialabs.xlrelease.domain.versioning.ascode.GitBranch;
import com.xebialabs.xlrelease.domain.versioning.ascode.VersioningStyle;
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReport;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationReportMessage;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningPreviewService;
import com.xebialabs.xlrelease.versioning.ascode.scm.FolderVersioningService;
import com.xebialabs.xlrelease.versioning.ascode.scm.strategy.VersioningStrategyResolver;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.Date;
import org.springframework.stereotype.Controller;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u0012%\u0001EB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011%\u0004!\u0011!Q\u0001\n)DQ!\u001c\u0001\u0005\u00029DQ\u0001\u001f\u0001\u0005BeDa\u0001\u001f\u0001\u0005B\u0005%\u0002bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\t\u0019\u0006\u0001C!\u0003_Bq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002~\u0002!\t%a@\t\u000f\u0005u\b\u0001\"\u0011\u0003\b!9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqA!\u000b\u0001\t\u0003\u0012Y\u0003C\u0004\u0003:\u0001!\tEa\u000f\t\u000f\t\u0015\u0003\u0001\"\u0011\u0003H!9!1\n\u0001\u0005B\t5\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005K\u0012qCR8mI\u0016\u0014h+\u001a:tS>t\u0017N\\4Ba&LU\u000e\u001d7\u000b\u0005\u00152\u0013\u0001B5na2T!a\n\u0015\u0002\u0005Y\f$BA\u0015+\u0003\r\t\u0007/\u001b\u0006\u0003W1\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00055r\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0013aA2p[\u000e\u00011c\u0001\u00013uA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005Y\u0006twMC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$AB(cU\u0016\u001cG\u000f\u0005\u0002<y5\ta%\u0003\u0002>M\t\u0019bi\u001c7eKJ4VM]:j_:LgnZ!qS\u0006\t\u0002/\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tS\u0013\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u0011\u000b%!\u0005)fe6L7o]5p]\u000eCWmY6fe\u00069bm\u001c7eKJ4VM]:j_:LgnZ*feZL7-\u001a\t\u0003\u000f:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b1a]2n\u0015\tYE*\u0001\u0004bg\u000e|G-\u001a\u0006\u0003\u001b*\n!B^3sg&|g.\u001b8h\u0013\ty\u0005JA\fG_2$WM\u001d,feNLwN\\5oON+'O^5dK\u0006q\u0001O]3wS\u0016<8+\u001a:wS\u000e,\u0007CA$S\u0013\t\u0019\u0006J\u0001\u0010G_2$WM\u001d,feNLwN\\5oOB\u0013XM^5foN+'O^5dK\u0006abm\u001c7eKJ4VM]:j_:LgnZ!di>\u00148+\u001a:wS\u000e,\u0007C\u0001,Z\u001b\u00059&B\u0001-K\u0003\u0019\t7\r^8sg&\u0011!l\u0016\u0002\u001d\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\f5\r^8s'\u0016\u0014h/[2f\u0003]1XM]:j_:LgnZ*us2,'+Z:pYZ,'\u000f\u0005\u0002^A6\taL\u0003\u0002`\u0011\u0006A1\u000f\u001e:bi\u0016<\u00170\u0003\u0002b=\nQb+\u001a:tS>t\u0017N\\4TiJ\fG/Z4z%\u0016\u001cx\u000e\u001c<fe\u0006!2m\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0016\u0002\u000fM,'O^5dK&\u0011\u0001.\u001a\u0002\u0015\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\u001b\u0019|G\u000eZ3s'\u0016\u0014h/[2f!\t!7.\u0003\u0002mK\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003C8reN$XO^<\u0011\u0005A\u0004Q\"\u0001\u0013\t\u000byB\u0001\u0019A \t\u000b\u0015C\u0001\u0019\u0001$\t\u000bAC\u0001\u0019A)\t\u000bQC\u0001\u0019A+\t\u000bmC\u0001\u0019\u0001/\t\u000b\tD\u0001\u0019A2\t\u000b%D\u0001\u0019\u00016\u0002\u0017\u001d,GOV3sg&|gn\u001d\u000b\u0006u\u0006\u0005\u0011q\u0004\t\u0003wzl\u0011\u0001 \u0006\u0003{\u001a\nQA^5foNL!a ?\u0003\u0019Y+'o]5p]N4\u0016.Z<\t\u000f\u0005\r\u0011\u00021\u0001\u0002\u0006\u0005Aam\u001c7eKJLE\r\u0005\u0003\u0002\b\u0005ea\u0002BA\u0005\u0003+\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0001\u0014A\u0002\u001fs_>$hH\u0003\u0002\u0002\u0014\u0005)1oY1mC&!\u0011qCA\t\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*!\u0011qCA\t\u0011\u001d\t\t#\u0003a\u0001\u0003G\tABZ3uG\"\u001c\u0005.\u00198hKN\u00042aMA\u0013\u0013\r\t9\u0003\u000e\u0002\b\u0005>|G.Z1o)\rQ\u00181\u0006\u0005\b\u0003\u0007Q\u0001\u0019AA\u0003\u000399W\r^!mY\n\u0013\u0018M\\2iKN$b!!\r\u0002N\u0005=\u0003CBA\u001a\u0003s\ti$\u0004\u0002\u00026)\u0019\u0011q\u0007\u001c\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\t)D\u0001\u0003MSN$\b\u0003BA \u0003\u0013j!!!\u0011\u000b\u0007-\u000b\u0019EC\u0002N\u0003\u000bR1!a\u0012+\u0003\u0019!w.\\1j]&!\u00111JA!\u0005%9\u0015\u000e\u001e\"sC:\u001c\u0007\u000eC\u0004\u0002\u0004-\u0001\r!!\u0002\t\u000f\u0005E3\u00021\u0001\u0002\u0006\u0005A1m\u001c8gS\u001eLE-A\u0007de\u0016\fG/\u001a,feNLwN\u001c\u000b\u0007\u0003/\ni&a\u0018\u0011\u0007m\fI&C\u0002\u0002\\q\u00141BV3sg&|g.\u00138g_\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0001bBA1\u0019\u0001\u0007\u00111M\u0001\fm\u0016\u00148/[8o\r>\u0014X\u000e\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIGJ\u0001\u0005M>\u0014X.\u0003\u0003\u0002n\u0005\u001d$!E\"sK\u0006$XMV3sg&|gNR8s[RA\u0011qKA9\u0003g\n9\bC\u0004\u0002\u00045\u0001\r!!\u0002\t\u000f\u0005UT\u00021\u0001\u0002\u0006\u0005Ya/\u001a:tS>tg*Y7f\u0011\u001d\tI(\u0004a\u0001\u0003\u000b\t1\u0002Z3tGJL\u0007\u000f^5p]\u0006a\u0011\r\u001d9msZ+'o]5p]R1\u0011qPAF\u0003\u001b\u0003B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b\t%\u0001\u0006wC2LG-\u0019;j_:LA!!#\u0002\u0004\n\u0001b+\u00197jI\u0006$\u0018n\u001c8SKB|'\u000f\u001e\u0005\b\u0003\u0007q\u0001\u0019AA\u0003\u0011\u001d\tyI\u0004a\u0001\u0003\u000b\tqA^3sg&|g.\u0001\bqe\u00164\u0018.Z<DkJ\u0014XM\u001c;\u0015\r\u0005\u0015\u0011QSAL\u0011\u001d\t\u0019a\u0004a\u0001\u0003\u000bAq!!'\u0010\u0001\u0004\t)!\u0001\u0005gS2,g.Y7f\u00039\u0001(/\u001a<jK^4VM]:j_:$\u0002\"!\u0002\u0002 \u0006\u0005\u00161\u0015\u0005\b\u0003\u0007\u0001\u0002\u0019AA\u0003\u0011\u001d\ty\t\u0005a\u0001\u0003\u000bAq!!'\u0011\u0001\u0004\t)!A\u000bhKR4VM]:j_:,GMR5mK:\u000bW.Z:\u0015\r\u0005%\u00161VAW!\u0019\t\u0019$!\u000f\u0002\u0006!9\u00111A\tA\u0002\u0005\u0015\u0001bBAH#\u0001\u0007\u0011QA\u0001\u001fO\u0016$8)\u001e:sK:$h+\u001a:tS>t\u0017M\u00197f\r&dWMT1nKN$B!!+\u00024\"9\u00111\u0001\nA\u0002\u0005\u0015\u0011aC4fiN+G\u000f^5oON$B!!/\u0002FB!\u00111XAa\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0013\u0001C:fiRLgnZ:\n\t\u0005\r\u0017Q\u0018\u0002\u0019\r>dG-\u001a:WKJ\u001c\u0018n\u001c8j]\u001e\u001cV\r\u001e;j]\u001e\u001c\bbBA\u0002'\u0001\u0007\u0011Q\u0001\u0015\t\u0003\u000b\fI-!8\u0002`B!\u00111ZAm\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017A\u0001:t\u0015\u0011\t\u0019.!6\u0002\u0005]\u001c(BAAl\u0003\u001dQ\u0017m[1si\u0006LA!a7\u0002N\nI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0007\ta\"\u001e9eCR,7+\u001a;uS:<7\u000f\u0006\u0004\u0002:\u0006\u0015\u0018\u0011\u001e\u0005\b\u0003\u0007!\u0002\u0019AA\u0003Q!\t)/!3\u0002^\u0006}\u0007bBAv)\u0001\u0007\u0011\u0011X\u0001\u0007G>tg-[4\u0002\u001d\u0011,G.\u001a;f'\u0016$H/\u001b8hgR!\u0011\u0011_A}!\u0011\t\u00190!>\u000e\u0005\u0005E\u0011\u0002BA|\u0003#\u0011A!\u00168ji\"9\u00111A\u000bA\u0002\u0005\u0015\u0001\u0006CA}\u0003\u0013\fi.a8\u0002\u001f\u0011,G.\u001a;f\u0019>\u001c\u0017\r\u001c*fa>$b!!=\u0003\u0002\t\r\u0001bBA\u0002-\u0001\u0007\u0011Q\u0001\u0005\b\u0005\u000b1\u0002\u0019AA\u0012\u0003-\u0019G.^:uKJ<\u0016\u000eZ3\u0015\t\u0005E(\u0011\u0002\u0005\b\u0003\u00079\u0002\u0019AA\u0003\u00039\u0011Xm]3u\u0019>\u001c\u0017\r\u001c*fa>$b!!=\u0003\u0010\tE\u0001bBA\u00021\u0001\u0007\u0011Q\u0001\u0005\b\u0005\u000bA\u0002\u0019AA\u0012\u0003=1\u0018\r\\5eCR,7)\u001e:sK:$H\u0003BA@\u0005/Aq!a\u0001\u001a\u0001\u0004\t)!A\u000bhKR4\u0016\r\\5eCRLwN\\'fgN\fw-Z:\u0015\t\u0005}$Q\u0004\u0005\b\u0003\u0007Q\u0002\u0019AA\u0003\u0003U\u0019X\r\u001e,bY&$\u0017\r^5p]6+7o]1hKN$b!!=\u0003$\t\u0015\u0002bBA\u00027\u0001\u0007\u0011Q\u0001\u0005\b\u0005OY\u0002\u0019AA@\u0003A1\u0018\r\\5eCRLwN\u001c*fa>\u0014H/\u0001\u000bhKR4\u0016\r\\5eCRLwN\\'fgN\fw-\u001a\u000b\u0007\u0005[\u0011\u0019D!\u000e\u0011\t\u0005\u0005%qF\u0005\u0005\u0005c\t\u0019IA\fWC2LG-\u0019;j_:\u0014V\r]8si6+7o]1hK\"9\u00111\u0001\u000fA\u0002\u0005\u0015\u0001b\u0002B\u001c9\u0001\u0007\u0011QA\u0001\n[\u0016\u001c8/Y4f\u0013\u0012\f1d]3u-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,7o\u0015;biV\u001cH\u0003CAy\u0005{\u0011yD!\u0011\t\u000f\u0005\rQ\u00041\u0001\u0002\u0006!9!qG\u000fA\u0002\u0005\u0015\u0001b\u0002B\";\u0001\u0007!QF\u0001\u0012m\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,\u0017\u0001D2mK\u0006\u00148+Z2sKR\u001cH\u0003BAy\u0005\u0013Bq!a\u0001\u001f\u0001\u0004\t)!A\nhKR4VM]:j_:LgnZ*us2,7\u000f\u0006\u0002\u0003PA1\u00111GA\u001d\u0005#\u0002B!a\u0010\u0003T%!!QKA!\u0005=1VM]:j_:LgnZ*us2,\u0017\u0001\t<bY&$\u0017\r^3G_2$WM\u001d,feNLwN\\5oON+G\u000f^5oON$B!!=\u0003\\!9\u00111\u001e\u0011A\u0002\u0005e\u0016a\u0006<bY&$\u0017\r^3WKJ\u001c\u0018n\u001c8j]\u001e\u001cF/\u001f7f)\u0011\t\tP!\u0019\t\u000f\u0005-\u0018\u00051\u0001\u0002:\u0006)b/\u00197jI\u0006$XmR5u\u0007>tg.Z2uS>tG\u0003BAy\u0005OBq!a;#\u0001\u0004\tI\fK\u0002\u0001\u0005W\u0002BA!\u001c\u0003|5\u0011!q\u000e\u0006\u0005\u0005c\u0012\u0019(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TAA!\u001e\u0003x\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0003z\u0005\u0019qN]4\n\t\tu$q\u000e\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b")
public class FolderVersioningApiImpl
implements FolderVersioningApi {
    private final PermissionChecker permissionChecker;
    private final FolderVersioningService folderVersioningService;
    private final FolderVersioningPreviewService previewService;
    private final FolderVersioningActorService folderVersioningActorService;
    private final VersioningStrategyResolver versioningStyleResolver;
    private final ConfigurationService configurationService;
    private final FolderService folderService;

    public String serviceName() {
        return super.serviceName();
    }

    public VersionsView getVersions(String folderId, Boolean fetchChanges) {
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple2;
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        Tuple2<Date, scala.collection.immutable.Seq<VersionInfo>> tuple22 = tuple2 = Predef$.MODULE$.Boolean2boolean(fetchChanges) ? this.folderVersioningActorService.fetchChanges(folderId) : this.folderVersioningService.getVersions(folderId);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Date lastFetched = (Date)tuple2._1();
        scala.collection.immutable.Seq versions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)lastFetched, (Object)versions);
        Date lastFetched2 = (Date)tuple23._1();
        scala.collection.immutable.Seq versions2 = (scala.collection.immutable.Seq)tuple23._2();
        return new VersionsView(lastFetched2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)versions2).asJava());
    }

    public VersionsView getVersions(String folderId) {
        return this.getVersions(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public java.util.List<GitBranch> getAllBranches(String folderId, String configId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getAllBranches(configId)).asJava();
    }

    public VersionInfo createVersion(String folderId, CreateVersionForm versionForm) {
        this.permissionChecker.check(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)versionForm.getName()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (String)"Version name must be provided.", (Object[])new Object[0]);
        return this.folderVersioningActorService.createVersion(folderId, versionForm.getName(), (String)Option$.MODULE$.apply((Object)versionForm.getDescription()).getOrElse((Function0 & Serializable)() -> ""));
    }

    public VersionInfo createVersion(String folderId, String versionName, String description) {
        CreateVersionForm createVersionForm = new CreateVersionForm();
        createVersionForm.setName(versionName);
        createVersionForm.setDescription(description);
        return this.createVersion(folderId, createVersionForm);
    }

    public ValidationReport applyVersion(String folderId, String version) {
        this.permissionChecker.checkAny(folderId, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.APPLY_FOLDER_CHANGES}));
        return this.folderVersioningService.applyVersion(folderId, version);
    }

    public String previewCurrent(String folderId, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)None$.MODULE$, (String)Option$.MODULE$.apply((Object)filename).getOrElse((Function0 & Serializable)() -> ""));
    }

    public String previewVersion(String folderId, String version, String filename) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.previewService.generatePreview(folderId, (Option<String>)new Some((Object)version), filename);
    }

    public java.util.List<String> getVersionedFileNames(String folderId, String version) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionedFileNames(folderId, version)).asJava();
    }

    public java.util.List<String> getCurrentVersionableFileNames(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersionableFileNames(folderId)).asJava();
    }

    public FolderVersioningSettings getSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (FolderVersioningSettings)this.folderVersioningService.findSettings(folderId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public FolderVersioningSettings updateSettings(@PathParam(value="folderId") String folderId, FolderVersioningSettings config) {
        FolderVersioningSettings folderVersioningSettings;
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.validateFolderVersioningSettings(config);
        config.setFolderId(folderId);
        try {
            folderVersioningSettings = this.folderVersioningActorService.createOrUpdateSettings(config);
        }
        catch (ScmException e) {
            throw new IllegalArgumentException("Unable to update folder versioning settings: " + e.getMessage(), e);
        }
        return folderVersioningSettings;
    }

    public void deleteSettings(@PathParam(value="folderId") String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.folderService.exists(folderId), (String)("Folder '" + folderId + "' does not exist in the repository."), (Object[])new Object[0]);
        this.folderVersioningActorService.cleanLocalRepo(folderId, true);
        this.folderVersioningService.deleteSettings(folderId);
    }

    public void deleteLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.cleanLocalRepo(folderId, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public void deleteLocalRepo(String folderId) {
        this.deleteLocalRepo(folderId, Predef$.MODULE$.boolean2Boolean(false));
    }

    public void resetLocalRepo(String folderId, Boolean clusterWide) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        FolderVersioningSettings config = this.folderVersioningService.getSettings(folderId);
        this.folderVersioningActorService.resetLocalRepo(config, Predef$.MODULE$.Boolean2boolean(clusterWide));
    }

    public ValidationReport validateCurrent(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.validate(folderId);
    }

    public ValidationReport getValidationMessages(String folderId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return this.folderVersioningService.getValidationMessages(folderId);
    }

    public void setValidationMessages(String folderId, ValidationReport validationReport) {
        this.permissionChecker.check(XLReleasePermissions.EDIT_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.setValidationMessages(folderId, (scala.collection.immutable.Seq<ValidationReportMessage>)CollectionConverters$.MODULE$.ListHasAsScala(validationReport.getWarnings()).asScala().toSeq());
    }

    public ValidationReportMessage getValidationMessage(String folderId, String messageId) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        return (ValidationReportMessage)Option$.MODULE$.apply((Object)this.folderVersioningService.getValidationMessage(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Validation message with id " + messageId + " not found");
        });
    }

    public void setValidationMessagesStatus(String folderId, String messageId, ValidationReportMessage validationMessage) {
        this.permissionChecker.check(XLReleasePermissions.VIEW_FOLDER_VERSIONS, folderId);
        this.folderVersioningService.updateValidationMessageStatus(Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(messageId))), validationMessage);
    }

    public void clearSecrets(String folderId) {
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        this.folderVersioningActorService.clearSecrets(folderId);
    }

    public java.util.List<VersioningStyle> getVersioningStyles() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folderVersioningService.getVersioningStyles()).asJava();
    }

    private void validateFolderVersioningSettings(FolderVersioningSettings config) {
        this.validateVersioningStyle(config);
        this.validateGitConnection(config);
    }

    private void validateVersioningStyle(FolderVersioningSettings config) {
        Option styleInput = Option$.MODULE$.apply((Object)config.getVersioningStyle()).map((Function1 & Serializable)x$3 -> x$3.trim());
        boolean bl = false;
        Some some = null;
        Option option = styleInput;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String style = (String)some.value();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(style))) {
                List<VersioningStyle> supported = this.versioningStyleResolver.supportedStyles();
                String canonical = (String)supported.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)FolderVersioningApiImpl.$anonfun$validateVersioningStyle$2(style, s))).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> {
                    String allowed = supported.map((Function1 & Serializable)x$5 -> x$5.id()).mkString(", ");
                    throw new IllegalArgumentException("Invalid versioningStyle '" + style + "'. Supported versioning styles: " + allowed);
                });
                config.setVersioningStyle(canonical);
                return;
            }
        }
        if (bl) {
            String allowed = this.versioningStyleResolver.supportedStyles().map((Function1 & Serializable)x$6 -> x$6.id()).mkString(", ");
            throw new IllegalArgumentException("Missing versioningStyle. Supported versioning styles: " + allowed);
        }
        throw new MatchError((Object)option);
    }

    private void validateGitConnection(FolderVersioningSettings config) {
        boolean gitConnectionValid = Option$.MODULE$.apply((Object)config.getGitConnection()).exists((Function1 & Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)this.configurationService.exists(conn.getId())));
        Checks.checkArgument((boolean)gitConnectionValid, (String)"A valid gitConnection must be specified.", (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$validateVersioningStyle$2(String style$1, VersioningStyle s) {
        return s.id().equalsIgnoreCase(style$1);
    }

    public FolderVersioningApiImpl(PermissionChecker permissionChecker, FolderVersioningService folderVersioningService, FolderVersioningPreviewService previewService, FolderVersioningActorService folderVersioningActorService, VersioningStrategyResolver versioningStyleResolver, ConfigurationService configurationService, FolderService folderService) {
        this.permissionChecker = permissionChecker;
        this.folderVersioningService = folderVersioningService;
        this.previewService = previewService;
        this.folderVersioningActorService = folderVersioningActorService;
        this.versioningStyleResolver = versioningStyleResolver;
        this.configurationService = configurationService;
        this.folderService = folderService;
    }
}

