package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.FolderFilterStringReferenceCreationHandler._
import com.xebialabs.xlrelease.udm.reporting.filters.impl.FolderFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

object FolderFilterStringReferenceCreationHandler {
  val folderIdField = "folderId"

  def folderIdDescriptor: PropertyDescriptor = typeOf[FolderFilter].getDescriptor.getPropertyDescriptor(folderIdField)

  val properties: Set[String] = Set(
    folderIdField
  )
}

@Component
class FolderFilterStringReferenceCreationHandler @Autowired()(folderAsCodeService: FolderAsCodeService)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    config.ci.isInstanceOf[FolderFilter] &&
      (folderIdDescriptor.get(config.ci) != null)
  }

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {

    val folderId = Option(folderIdDescriptor.get(config.ci)) match {
      case Some(folderPath: String) =>
        folderAsCodeService.searchFolder(FolderAsCodeService.absolutePath(folderPath, config.home)) match {
          case Some(folder) => folder.getName
          case None => throw new AsCodeException(s"Cannot find folder with name [${folderIdDescriptor.get(config.ci).asInstanceOf[String]}] should be created first before trying to use it.")
        }
      case _ => Option.empty
    }

    StringReferenceContainer(config.ci, Map(folderIdDescriptor -> Some(folderId)))
  }
}
