/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService$;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.triggers.actors.TriggerLifecycle;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u000f\u001f\u0001%B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011\u0005\u0004!\u0011!Q\u0001\n\tD\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\")!\u000f\u0001C\u0001g\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!a \u0001\t\u0013\t\t\tC\u0005\u0002.\u0002\t\n\u0011\"\u0003\u00020\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0002x\u0002!I!!?\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005WAqAa\f\u0001\t\u0013\u0011\tD\u0001\u000bUe&<w-\u001a:Bg\u000e{G-Z*feZL7-\u001a\u0006\u0003?\u0001\nqa]3sm&\u001cWM\u0003\u0002\"E\u00051\u0011m]2pI\u0016T!a\t\u0013\u0002\u0013ad'/\u001a7fCN,'BA\u0013'\u0003%AXMY5bY\u0006\u00147OC\u0001(\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B:mMRR'\"A\u001b\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u000e\u001a\u0003\u000f1{wmZ5oO\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0013A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011ah\u000f\u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011!(Q\u0005\u0003\u0005n\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"!R$\u000e\u0003\u0019S!a\b\u0012\n\u0005!3%A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005\u0015[\u0015B\u0001'G\u000551u\u000e\u001c3feN+'O^5dK\u0006y!/\u001a4fe\u0016t7-Z*pYZ,'\u000f\u0005\u0002P!6\ta$\u0003\u0002R=\ty!+\u001a4fe\u0016t7-Z*pYZ,'/\u0001\tue&<w-\u001a:MS\u001a,7-_2mKB\u0019A+W.\u000e\u0003US!AV,\u0002\r\u0005\u001cGo\u001c:t\u0015\tA&%\u0001\u0005ue&<w-\u001a:t\u0013\tQVK\u0001\tUe&<w-\u001a:MS\u001a,7-_2mKB\u0011AlX\u0007\u0002;*\u0011aLI\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0001l&a\u0002+sS\u001e<WM]\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002FG&\u0011AM\u0012\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\bue&<w-\u001a:TKJ4\u0018nY3\u0011\u0005\u001dLW\"\u00015\u000b\u0005}9\u0016B\u00016i\u00059!&/[4hKJ\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_\n\na!\u001a<f]R\u001c\u0018BA9o\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015Q,ho\u001e=zundX\u0010\u0005\u0002P\u0001!)\u0001H\u0003a\u0001s!)qH\u0003a\u0001\u0001\")1I\u0003a\u0001\t\")\u0011J\u0003a\u0001\u0015\")QJ\u0003a\u0001\u001d\")!K\u0003a\u0001'\")\u0011M\u0003a\u0001E\")QM\u0003a\u0001M\")1N\u0003a\u0001Y\"\u0012!b \t\u0005\u0003\u0003\t9\"\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0013\tY!A\u0004gC\u000e$xN]=\u000b\t\u00055\u0011qB\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003#\t\u0019\"A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t)\"A\u0002pe\u001eLA!!\u0007\u0002\u0004\tI\u0011)\u001e;po&\u0014X\rZ\u0001\baJ|7-Z:t)\u0019\ty\"!\n\u00026A\u0019q*!\t\n\u0007\u0005\rbD\u0001\u0007J[B|'\u000f\u001e*fgVdG\u000fC\u0004\u0002(-\u0001\r!!\u000b\u0002\u000f\r|g\u000e^3yiB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u0001\nQ!\u001e;jYNLA!a\r\u0002.\ti\u0011*\u001c9peR\u001cuN\u001c;fqRDa!a\u000e\f\u0001\u0004Y\u0016a\u0002;sS\u001e<WM]\u0001\u000faJ|7-Z:t)JLwmZ3s)\u0019\ti$a\u0011\u0002FA\u00191&a\u0010\n\u0007\u0005\u0005CF\u0001\u0003V]&$\bbBA\u0014\u0019\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0003oa\u0001\u0019A.\u0002\r\r\u0014X-\u0019;f)!\ty\"a\u0013\u0002N\u0005=\u0003bBA\u0014\u001b\u0001\u0007\u0011\u0011\u0006\u0005\u0007\u0003oi\u0001\u0019A.\t\u000f\u0005ES\u00021\u0001\u0002T\u0005IAO]5hO\u0016\u0014\u0018\n\u001a\t\u0005\u0003+\n\u0019G\u0004\u0003\u0002X\u0005}\u0003cAA-Y5\u0011\u00111\f\u0006\u0004\u0003;B\u0013A\u0002\u001fs_>$h(C\u0002\u0002b1\na\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1Y\u00051Q\u000f\u001d3bi\u0016$\"\"a\b\u0002n\u0005=\u00141OA;\u0011\u001d\t9C\u0004a\u0001\u0003SAa!!\u001d\u000f\u0001\u0004Y\u0016\u0001C3ySN$\u0018N\\4\t\r\u0005]b\u00021\u0001\\\u0011\u001d\t9H\u0004a\u0001\u0003s\nQD]3mK\u0006\u001cXMR8mI\u0016\u0014x*\u001e;PMN\u001bw\u000e]3Fq&\u001cHo\u001d\t\u0004W\u0005m\u0014bAA?Y\t9!i\\8mK\u0006t\u0017\u0001\u0003<bY&$\u0017\r^3\u0015\u0011\u0005\r\u0015qUAU\u0003W\u0003b!!\"\u0002\u0010\u0006Ue\u0002BAD\u0003\u0017sA!!\u0017\u0002\n&\tQ&C\u0002\u0002\u000e2\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0006M%\u0001\u0002'jgRT1!!$-!\u0011\t9*a)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b!B^1mS\u0012\fG/[8o\u0015\r\t\u0013q\u0014\u0006\u0004\u0003Ck\u0016A\u0003<feNLwN\\5oO&!\u0011QUAM\u0005E1\u0016\r\\5eCRLwN\\'fgN\fw-\u001a\u0005\b\u0003Oy\u0001\u0019AA\u0015\u0011\u0019\t9d\u0004a\u00017\"I\u0011qO\b\u0011\u0002\u0003\u0007\u0011\u0011P\u0001\u0013m\u0006d\u0017\u000eZ1uK\u0012\"WMZ1vYR$3'\u0006\u0002\u00022*\"\u0011\u0011PAZW\t\t)\f\u0005\u0003\u00028\u0006}VBAA]\u0015\u0011\tY,!0\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003Y%!\u0011\u0011YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017m\u0006d\u0017\u000eZ1uKN#xN]3e)JLwmZ3sgR!\u0011QHAd\u0011\u001d\tI-\u0005a\u0001\u0003\u0017\fab\u001d;pe\u0016$GK]5hO\u0016\u00148\u000fE\u0003\u0002\u0006\u0006=5,\u0001\u0007gS:$G+Z7qY\u0006$X\r\u0006\u0004\u0002R\u0006]\u00171\u001c\t\u00049\u0006M\u0017bAAk;\n9!+\u001a7fCN,\u0007bBAm%\u0001\u0007\u00111K\u0001\nS\u0012|%\u000fV5uY\u0016Dq!!8\u0013\u0001\u0004\t\u0019&\u0001\u0007qCJ,g\u000e\u001e$pY\u0012,'/\u0001\tgS:$G+Z7qY\u0006$XMQ=JIR1\u0011\u0011[Ar\u0003KDq!!7\u0014\u0001\u0004\t\u0019\u0006C\u0004\u0002^N\u0001\r!a\u0015\u0002'\u0019Lg\u000e\u001a+f[Bd\u0017\r^3CsRKG\u000f\\3\u0015\r\u0005E\u00171^Aw\u0011\u001d\tI\u000e\u0006a\u0001\u0003'Bq!!8\u0015\u0001\u0004\t\u0019&\u0001\fsKN|GN^3SK2,\u0017m]3G_2$WM]%e)\u0011\t\u0019&a=\t\u000f\u0005UX\u00031\u0001\u0002T\u0005y!/\u001a7fCN,gi\u001c7eKJLE-\u0001\ttKR\u0014V\r\\3bg\u00164u\u000e\u001c3feR!\u0011QHA~\u0011\u001d\t9D\u0006a\u0001\u0003{\u00042\u0001XA\u0000\u0013\r\u0011\t!\u0018\u0002\u000f%\u0016dW-Y:f)JLwmZ3s\u0003a)\b\u000fZ1uKR\u0013\u0018nZ4feN\u0004&o\u001c9feRLWm\u001d\u000b\t\u0003{\u00119A!\u0003\u0003\f!1\u0011qG\fA\u0002mCq!!8\u0018\u0001\u0004\t\u0019\u0006C\u0004\u0003\u000e]\u0001\rAa\u0004\u0002\t!|W.\u001a\t\u0006W\tE\u00111K\u0005\u0004\u0005'a#AB(qi&|g.\u0001\u0006hK:,'/\u0019;f\u0013\u0012$B!a\u0015\u0003\u001a!9!1\u0004\rA\u0002\u0005M\u0013\u0001\u00039be\u0016tG/\u00133\u0002!Y\fG.\u001b3bi\u00164u\u000e\u001c3fe&#G\u0003BA\u001f\u0005CAa!a\u000e\u001a\u0001\u0004Y\u0016aD;qI\u0006$XMV1sS\u0006\u0014G.Z:\u0015\t\u0005u\"q\u0005\u0005\u0007\u0003oQ\u0002\u0019A.\u0002\u001b\u0015t\u0017M\u00197f)JLwmZ3s)\u0011\tiD!\f\t\r\u0005]2\u00041\u0001\\\u0003Y\u0019w\u000e]=J]R,'O\\1m!J|\u0007/\u001a:uS\u0016\u001cHCBA\u001f\u0005g\u0011)\u0004\u0003\u0004\u0002rq\u0001\ra\u0017\u0005\u0007\u0005oa\u0002\u0019A.\u0002\u001dU\u0004H-\u0019;fIR\u0013\u0018nZ4fe\"\u001a\u0001Aa\u000f\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQAA!\u0011\u0002\u0010\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\u0015#q\b\u0002\b'\u0016\u0014h/[2f\u0001")
public class TriggerAsCodeService
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final ReferenceSolver referenceSolver;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerAsCodeService triggerAsCodeService = this;
        synchronized (triggerAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Trigger trigger) {
        boolean bl;
        ReleaseTrigger releaseTrigger;
        this.logger().debug((Function0 & Serializable)() -> "Processing trigger: " + trigger.toString() + " with metadata " + context.metadata().toString());
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger && (releaseTrigger = (ReleaseTrigger)trigger2).getReleaseFolder() != null && !releaseTrigger.getReleaseFolder().startsWith("./")) {
            Option folderExists = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(releaseTrigger.getReleaseFolder(), releaseTrigger.getReleaseFolder().split("/").length - 1)).toOption();
            bl = folderExists.isDefined();
        } else {
            bl = true;
        }
        boolean releaseFolderOutOfScopeExists = bl;
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        List storedTriggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(parentFolder, false, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().toList();
        this.validateStoredTriggers((List<Trigger>)storedTriggers);
        this.processTrigger(context, trigger);
        Option option = storedTriggers.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$process$4(trigger, x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Trigger existing = (Trigger)some.value();
            this.logger().debug((Function0 & Serializable)() -> "Updating trigger: " + existing.toString());
            return this.update(context, existing, trigger, releaseFolderOutOfScopeExists);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating trigger: " + trigger.toString());
            return this.create(context, trigger, this.generateId(parentFolder));
        }
        throw new MatchError((Object)option);
    }

    private void processTrigger(ImportContext context, Trigger trigger) {
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        Option home = context.metadata().get((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)trigger, context.references(), parentFolder);
        this.updateTriggersProperties(trigger, parentFolder, (Option<String>)home);
        this.validateFolderId(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
    }

    private ImportResult create(ImportContext context, Trigger trigger, String triggerId) {
        trigger.setId(triggerId);
        Trigger created = this.triggerRepository.create(trigger);
        List<ValidationMessage> messages = this.validate(context, trigger, this.validate$default$3());
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> this.enableTrigger(created), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerCreatedFromAsCodeEvent(created, context.scmData())), (List)Nil$.MODULE$)), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private ImportResult update(ImportContext context, Trigger existing, Trigger trigger, boolean releaseFolderOutOfScopeExists) {
        trigger.setId(existing.getId());
        trigger.setCiUid(existing.getCiUid());
        this.copyInternalProperties(existing, trigger);
        List<ValidationMessage> messages = this.validate(context, trigger, releaseFolderOutOfScopeExists);
        Trigger updated = this.triggerRepository.update(trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (List)Nil$.MODULE$), (scala.collection.immutable.Seq<PostCommitAction>)new .colon.colon(() -> $this.triggerService.refreshTrigger(updated), (List)new .colon.colon(() -> this.enableTrigger(updated), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedFromAsCodeEvent(updated, context.scmData())), (List)Nil$.MODULE$))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Trigger trigger, boolean releaseFolderOutOfScopeExists) {
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            return validator.validateCi((ConfigurationItem)trigger, context.getFolderInfo(), releaseFolderOutOfScopeExists).toList();
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    private boolean validate$default$3() {
        return true;
    }

    private void validateStoredTriggers(List<Trigger> storedTriggers) {
        ((IterableOnceOps)storedTriggers.groupBy((Function1 & Serializable)x$2 -> x$2.getTitle()).values().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$validateStoredTriggers$2(x$3)))).foreach((Function1 & Serializable)triggerGroup -> {
            Trigger trigger = (Trigger)triggerGroup.head();
            throw new AsCodeException("More than one trigger with the name [" + trigger.getTitle() + "] is present in the repository. Don't know which one to update", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    public Release com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(String idOrTitle, String parentFolder) {
        if (Ids.isReleaseId((String)idOrTitle)) {
            return this.findTemplateById(idOrTitle, parentFolder);
        }
        return this.findTemplateByTitle(idOrTitle, parentFolder);
    }

    private Release findTemplateById(String idOrTitle, String parentFolder) {
        Release release;
        try {
            release = this.releaseService.findById(idOrTitle);
        }
        catch (LogFriendlyNotFoundException nfe) {
            release = this.findTemplateByTitle(idOrTitle, parentFolder);
        }
        catch (Exception e) {
            throw new AsCodeException("Failed to find template [" + idOrTitle + "], error [" + e.getMessage() + "].", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return release;
    }

    private Release findTemplateByTitle(String idOrTitle, String parentFolder) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List list = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle(parentFolder, idOrTitle, 0, 2, 1)).asScala().toList();
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            Release template = (Release)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return template;
            }
        }
        if (bl) {
            throw new ItemConflictException("More than one template with name [" + idOrTitle + "] is present in the folder [" + parentFolder + "]. Please use an unique name.", new Object[0]);
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new AsCodeException("There is no template with name [" + idOrTitle + "] under folder [" + parentFolder + "]", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)list);
    }

    public String com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(String releaseFolderId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(releaseFolderId), "/"), $this.folderService.findByPath$default$2()).getId());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String resolvedReleaseFolderID = (String)success.value();
            return resolvedReleaseFolderID;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw new AsCodeException("Unable to resolve release folder id, " + releaseFolderId + " for trigger: failure message " + ex.getMessage(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError((Object)try_);
    }

    private void setReleaseFolder(ReleaseTrigger trigger) {
        ObjectRef folderId = ObjectRef.create((Object)trigger.getReleaseFolder());
        if ((String)folderId.elem != null) {
            String string;
            Option option;
            if (((String)folderId.elem).startsWith("./")) {
                String rootFolderPath = ((IterableOnceOps)this.folderService.getPath(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])trigger.getFolderId().split("/")), 2)).mkString("/")).drop(1)).mkString("/");
                folderId.elem = trigger.getReleaseFolder().replace("./", rootFolderPath + "/");
            }
            if ((option = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath((String)folderId$1.elem, ((String)folderId$1.elem).split("/").length - 1)).toOption()) instanceof Some) {
                Some some = (Some)option;
                Folder folder = (Folder)some.value();
                string = folder.getId();
            } else if (None$.MODULE$.equals(option)) {
                string = null;
            } else {
                throw new MatchError((Object)option);
            }
            String releaseFolder = string;
            trigger.setReleaseFolder(releaseFolder);
            return;
        }
    }

    private void updateTriggersProperties(Trigger trigger, String parentFolder, Option<String> home) {
        trigger.setFolderId(parentFolder);
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setTemplate(this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(releaseTrigger.getTemplate(), parentFolder).getId());
            this.setReleaseFolder(releaseTrigger);
            return;
        }
        if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$1(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(MappedProperty x1) {
                    MappedProperty mappedProperty = x1;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$3(eventBasedTrigger, templateId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$5(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(MappedProperty x2) {
                    MappedProperty mappedProperty = x2;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$7(eventBasedTrigger, folderId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return;
        }
        if (trigger2 instanceof StatusWebhookTrigger) {
            StatusWebhookTrigger statusWebhookTrigger = (StatusWebhookTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(statusWebhookTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$9(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(MappedProperty x3) {
                    MappedProperty mappedProperty = x3;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$11(statusWebhookTrigger, templateId)));
            statusWebhookTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(statusWebhookTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$13(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        return (B1)this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(MappedProperty x4) {
                    MappedProperty mappedProperty = x4;
                    return mappedProperty instanceof MappedProperty.StringValue;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$15(statusWebhookTrigger, folderId)));
            statusWebhookTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return;
        }
    }

    private String generateId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Trigger.class), parentId);
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            throw new AsCodeException("Failed to create trigger " + trigger.getTitle() + ", you cannot create trigger on the root folder. The root folder path is not supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            java.util.List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$4 -> !x$4.isPassword())).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$3(x$5)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$4(x$6)))).toList()).asJava());
            return;
        }
    }

    private void enableTrigger(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, false);
            return;
        }
        this.triggerLifecycle.disable(trigger);
    }

    private void copyInternalProperties(Trigger existing, Trigger updatedTrigger) {
        CollectionConverters$.MODULE$.ListHasAsScala(updatedTrigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
            updatedTrigger.setProperty(internalProperty, existing.getProperty(internalProperty));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$4(Trigger trigger$1, Trigger x$1) {
        String string = x$1.getTitle();
        String string2 = trigger$1.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateStoredTriggers$2(List x$3) {
        return x$3.length() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$1(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$3(EventBasedTrigger x3$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$5(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$7(EventBasedTrigger x3$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$9(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$11(StatusWebhookTrigger x4$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x4$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$13(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$15(StatusWebhookTrigger x4$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x4$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$2, Variable v) {
        return x2$2.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$5) {
        return x$5._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$6) {
        return x$6.getId() != null;
    }

    @Autowired
    public TriggerAsCodeService(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, FolderService folderService, ReferenceSolver referenceSolver, TriggerLifecycle<Trigger> triggerLifecycle, CiIdService ciIdService, TriggerService triggerService, XLReleaseEventBus eventBus) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.referenceSolver = referenceSolver;
        this.triggerLifecycle = triggerLifecycle;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

