package com.xebialabs.xlrelease.ascode.yaml.model.permission

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.yaml.model.permission.PermissionRelation
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._

import scala.jdk.CollectionConverters._

object TeamPermissionRelation {
  def parseTeam(node: JsonNode): Team = {
    val name = node.requiredString("name")
    val roles = node.listOfStrings("roles")
    val users = node.listOfStrings("users")
    val permissions = node.listOfStrings("permissions")

    Team(name, roles, users, permissions)
  }

  def parse(teamNode: JsonNode): TeamPermissionRelation = {
    val directory = teamNode.requiredString("directory")
    val teams = teamNode.requiredProperty("teams").asScala.map(parseTeam).toList
    TeamPermissionRelation(directory, teams)
  }
}

case class Team(name: String, @JsonInclude(Include.NON_EMPTY) roles: List[String], @JsonInclude(Include.NON_EMPTY) users: List[String], @JsonInclude(Include.NON_EMPTY) permissions: List[String])

case class TeamPermissionRelation(directory: String, @JsonInclude(Include.NON_EMPTY) teams: List[Team]) extends PermissionRelation
