package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.api.v1.TenantApi
import com.xebialabs.xlrelease.configuration.TenantLimit
import org.springframework.stereotype.Component
import org.springframework.util.StringUtils.hasText

@Component
class TenantLimitGeneratorHandler(tenantApi: TenantApi) extends CiReferenceGeneratorHandler {

  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[TenantLimit]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val tenantLimit = ciWithHome.ci.asInstanceOf[TenantLimit]

    if (hasText(tenantLimit.getTenantId)) {
      val tenant = tenantApi.getTenant(tenantLimit.getTenantId)
      tenantLimit.setTenantId(tenant.tenantName)
    }
  }
}
