package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.repository.ItemConflictException
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.service.ReleaseService
import com.xebialabs.xlrelease.variable.VariableHelper

import scala.jdk.CollectionConverters._

object TemplateStringReferenceCreationUtil {

  // scalastyle:off cyclomatic.complexity
  def mapWorkflowIdToProp(config: StringReferenceCreationConfig, propertyDescriptor: PropertyDescriptor, property: Object,
                          folderAsCodeService: FolderAsCodeService, releaseService: ReleaseService): Map[_ <: PropertyDescriptor, Option[String]] = {
    Option(property) match {
      case Some(templatePath: String) if !VariableHelper.containsVariables(templatePath) =>
        val pathAndTitle = Utils.parseAbsolutePath(templatePath).replaceRelativePath(config.home)

        val value = config.templateIds.get(pathAndTitle.absolutePath()) match {
          case Some(id) => Some(id)
          case None =>
            val folderId = pathAndTitle.folderPath.flatMap(folderAsCodeService.searchFolder(_)).map(_.getId).orNull
            val templates = releaseService.findTemplatesByTitle(folderId, pathAndTitle.title, 0, 2, 1).asScala
            if (templates.nonEmpty && templates.size > 1) {
              throw new ItemConflictException(
                s"More than one template with title [${pathAndTitle.title}] is present in the folder [$folderId]. Please use an unique name.")
            }
            templates.headOption.map(_.getId)
        }
        Map(propertyDescriptor -> value)
      case _ => Map.empty
    }
  }

  // scalastyle:off cyclomatic.complexity
  def mapFolderIdToProp(config: StringReferenceCreationConfig, propertyDescriptor: PropertyDescriptor,
                        folderAsCodeService: FolderAsCodeService): Map[_ <: PropertyDescriptor, Some[String]] = {
    Option(propertyDescriptor.get(config.ci)) match {
      case Some(folderPath: String) if !VariableHelper.containsVariables(folderPath) =>
        folderAsCodeService.searchFolder(FolderAsCodeService.absolutePath(folderPath, config.home)) match {
          case Some(folder) => Map(propertyDescriptor -> Some(folder.getId))
          case None => throw new AsCodeException(
            s"Cannot find folder with name [${propertyDescriptor.get(config.ci).asInstanceOf[String]}] should be created first before trying to use it.")
        }
      case _ => Map.empty
    }
  }
}
