package com.xebialabs.xlrelease.versioning.ascode.upgrader

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.repository.sql.{ConfigurationRowReader, SqlRepositoryAdapter}
import com.xebialabs.xlrelease.service.FolderService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.utils.TypeHelper
import com.xebialabs.xlrelease.versioning.ascode.VersioningUtils.getEffectiveTagPrefix
import grizzled.slf4j.Logging
import org.codehaus.jettison.json.JSONObject
import org.springframework.stereotype.Component

import scala.util.{Failure, Try}

@Component
class XLRelease220FolderVersioningTagPrefixUpgrade(configurationRepository: ConfigurationRepository,
                                                   configurationPersistence: ConfigurationPersistence,
                                                   folderService: FolderService,
                                                   val sqlRepositoryAdapter: SqlRepositoryAdapter)
  extends Upgrade with Logging with ConfigurationRowReader {

  private val ciType = Type.valueOf(classOf[FolderVersioningSettings])

  def upgradeFolderVersioningSettings(): Unit = {

    val folderVersioningSettingsConfigRow = configurationPersistence.findByTypes(
      TypeHelper.getAllSubtypesOf(ciType).map(_.toString))
    if (folderVersioningSettingsConfigRow.nonEmpty) {
      logger.info("Found Version control configuration for upgrade")
      folderVersioningSettingsConfigRow.map(configurationRow => (configurationRow._1, new JSONObject(configurationRow._2), configurationRow._3)).
        filter(_._2.has("tagPrefix")).foreach(config => {
        val folderVersionJson = config._2
        val tagPrefix = folderVersionJson.getString("tagPrefix")
        folderVersionJson.remove("tagPrefix")
        val folderVersioningSettings = readConfiguration[FolderVersioningSettings]((config._1, folderVersionJson.toString, config._3))
        folderVersioningSettings.foreach(versioningSetting => {
          val normalizedTagPrefix = getEffectiveTagPrefix(versioningSetting.getScmPath)
          if (!normalizedTagPrefix.equals(tagPrefix)) {
            val folderName = scala.util.Try(folderService.getTitle(versioningSetting.getFolderId)).getOrElse("")
            logger.info(s"Version Control Tag Prefix property for folder $folderName normalized from $tagPrefix to $normalizedTagPrefix")
          }
          configurationRepository.update[FolderVersioningSettings](versioningSetting)
        })


      })

    }

  }

  override def doUpgrade(): Boolean = {
    Try(upgradeFolderVersioningSettings()) match {
      case Failure(_) => logger.error("Unable to upgrade Version Control configuration")
      case _ =>
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#1")

}
